<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Platform Plugin Translation Strings
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the platform plugin blade
    | templates for settings and configuration pages.
    |
    */

    // General Settings
    'general' => [
        'basic_information' => '基本信息',
        'basic_information_description' => '您应用的基本详情',
        'app_name' => '应用名称',
        'app_name_placeholder' => '我的精彩应用',
        'app_name_help' => '显示在设备主屏幕上',
        'website_url' => '网站 URL',
        'website_url_placeholder' => 'https://example.com',
        'website_url_help' => '您网站或网络应用的完整 URL',
        'configuration' => '配置',
        'configuration_description' => '技术设置和标识符',
        'app_id' => '应用 ID',
        'app_id_tooltip' => '应用商店使用的唯一包标识符',
        'app_id_placeholder' => 'com.example.app',
        'app_id_help' => '应用 ID 创建后无法更改',
        'copy' => '复制',
        'copied' => '已复制！',
        'screen_orientation' => '屏幕方向',
        'screen_orientation_help' => '控制应用在设备上如何旋转',
        'orientation_system' => '系统',
        'orientation_portrait' => '竖屏',
        'orientation_landscape' => '横屏',
        'app_language' => '应用语言（ISO 代码）',
        'app_language_help' => '您应用内容的主要语言',
    ],

    // Design Settings
    'design' => [
        'layout_template' => '布局模板',
        'layout_template_description' => '为您的应用选择导航结构',
        'layout_app_bar_drawer' => '应用栏 + 抽屉',
        'layout_app_bar_tabs' => '应用栏 + 导航标签',
        'layout_app_bar' => '应用栏',
        'layout_blank' => '空白',
        'progress_indicator' => '进度指示器',
        'progress_indicator_help' => '页面加载时显示的加载指示器样式',
        'progress_disable' => '禁用',
        'progress_linear' => '线性',
        'progress_circular' => '圆形',
        'progress_indicator_color' => '进度指示器颜色',
        'progress_indicator_color_help' => '加载进度指示器的颜色',
        'show_app_bar_title' => '在应用栏中显示当前网页标题',
        'show_app_bar_title_help' => '在顶部栏中显示当前页面的标题',
        'nav_tab_icon_colors' => '导航标签图标颜色',
        'nav_tab_icon_colors_help' => '浅色和深色模式下未激活标签图标的颜色',
        'active_tab_colors' => '激活标签颜色',
        'active_tab_colors_help' => '浅色和深色模式下选中标签的颜色',
        'light_mode' => '浅色模式',
        'dark_mode' => '深色模式',
        'theme_colors' => '主题颜色',
        'theme_colors_description' => '定义您应用外观的主要颜色',
        'theme_color' => '主题颜色',
        'theme_color_help' => '整个应用中使用的主要颜色',
        'enable_dynamic_colors' => '启用 Material You 动态颜色（Android 12+）',
        'enable_dynamic_colors_help' => '启用后，您的应用将在 Android 12+ 设备上根据用户壁纸调整颜色。这将覆盖上面的主题颜色。',
        'text_color_light' => '文字颜色（浅色模式）',
        'text_color_light_help' => '浅色模式下的默认文字和图标颜色',
        'text_color_dark' => '文字颜色（深色模式）',
        'text_color_dark_help' => '深色模式下的默认文字和图标颜色',
    ],

    // Icon Settings
    'icon' => [
        'app_icon' => '应用图标',
        'app_icon_description' => '从 icon.kitchen 上传您的应用图标 ZIP 文件',
        'current_icon' => '当前图标',
        'icon_zip_uploaded' => '图标 ZIP 已上传',
        'icon_zip_uploaded_description' => '已提取的图标可用于 Android 和 Web 平台',
        'default_icon' => '默认图标',
        'default_icon_description' => '上传自定义图标以替换默认图标',
        'delete' => '删除',
        'upload_zip_file' => '上传 ZIP 文件',
        'upload_zip_help' => '来自 icon.kitchen 的 ZIP 文件（最大 10MB）',
        'how_to_create' => '如何创建您的图标：',
        'step_visit' => '访问',
        'step_design' => '设计您的应用图标',
        'step_download' => '下载包含所有平台图标的 ZIP 文件',
        'step_upload' => '在此处上传 ZIP 文件',
        'zip_file_info' => 'ZIP 文件应包含 Android 和 Web 平台的图标（最大 10MB）',
        'upload_icon' => '上传图标',
    ],

    // Splashscreen Settings
    'splashscreen' => [
        'appearance' => '启动画面外观',
        'appearance_description' => '自定义背景、显示时长和动画效果',
        'background_type' => '背景类型',
        'background_type_color' => '纯色',
        'background_type_image' => '背景图片',
        'background_color' => '背景颜色',
        'background_image' => '背景图片',
        'background_image_help' => '仅限 PNG（最大 2MB）',
        'delete_background_image' => '删除背景图片',
        'display_duration' => '显示时长：',
        'seconds' => '秒',
        'animation_effect' => '动画效果',
        'animation_fade' => '淡入淡出',
        'animation_slide' => '滑动',
        'animation_zoom' => '缩放',
        'animation_none' => '无',
        'branding' => '启动画面品牌',
        'branding_description' => '为启动画面添加徽标、标题、副标题和文字样式',
        'show_logo' => '在启动画面上显示徽标',
        'logo_image' => '徽标图片',
        'logo_image_help' => '建议使用透明背景的 PNG（最大 2MB）',
        'delete_logo' => '删除徽标',
        'logo_size' => '徽标大小：',
        'logo_size_small' => '小（60dp）',
        'logo_size_medium' => '中（150dp）',
        'logo_size_large' => '大（240dp）',
        'logo_size_help' => '调整徽标大小以获得最佳外观',
        'title' => '标题',
        'title_placeholder' => '我的精彩应用',
        'subtitle' => '副标题',
        'subtitle_placeholder' => '欢迎使用最棒的应用',
        'text_theme' => '文字主题',
        'text_theme_light' => '浅色（白色文字）',
        'text_theme_dark' => '深色（黑色文字）',
    ],

    // Drawer Settings
    'drawer' => [
        'appearance' => '抽屉外观',
        'appearance_description' => '自定义导航抽屉的背景和视觉样式',
        'drawer_mode' => '抽屉模式',
        'drawer_mode_help' => '选择抽屉背景的显示方式',
        'mode_default' => '默认（主题颜色）',
        'mode_color' => '自定义颜色',
        'mode_image' => '背景图片',
        'background_color' => '背景颜色',
        'background_color_help' => '抽屉的自定义背景颜色',
        'background_image' => '背景图片',
        'background_image_help' => '仅限 PNG（最大 2MB）。建议：1080x1920px',
        'delete_background_image' => '删除背景图片',
        'branding' => '抽屉品牌',
        'branding_description' => '在抽屉头部添加徽标、标题并自定义文字外观',
        'show_logo' => '在抽屉中显示徽标',
        'show_logo_help' => '在抽屉头部显示徽标',
        'logo_light' => '抽屉徽标（浅色模式）',
        'logo_light_help' => '需要透明背景的 PNG（最大 2MB）- 应用处于浅色主题时显示',
        'delete_light_logo' => '删除浅色徽标',
        'logo_dark' => '抽屉徽标（深色模式）',
        'logo_dark_help' => '需要透明背景的 PNG（最大 2MB）- 应用处于深色主题时显示',
        'delete_dark_logo' => '删除深色徽标',
        'logo_size' => '徽标大小：',
        'logo_size_small' => '小（40dp）',
        'logo_size_medium' => '中（120dp）',
        'logo_size_large' => '大（200dp）',
        'logo_size_help' => '调整徽标大小以获得最佳外观',
        'drawer_title' => '抽屉标题',
        'drawer_title_placeholder' => '我的应用',
        'drawer_title_help' => '显示在抽屉头部的标题',
        'drawer_subtitle' => '抽屉副标题',
        'drawer_subtitle_placeholder' => '欢迎使用我的应用',
        'drawer_subtitle_help' => '显示在标题下方的副标题或标语',
        'text_theme' => '文字主题',
        'text_theme_help' => '抽屉头部和菜单项的文字颜色',
        'text_theme_light' => '浅色（白色文字）',
        'text_theme_dark' => '深色（黑色文字）',
        'item_colors' => '抽屉项目颜色',
        'item_colors_description' => '自定义抽屉菜单项的图标和文字颜色',
        'item_icon_colors' => '抽屉项目图标颜色',
        'item_icon_colors_help' => '浅色和深色模式下未激活抽屉项目图标和文字的颜色',
        'active_item_colors' => '激活项目颜色',
        'active_item_colors_help' => '浅色和深色模式下选中/激活抽屉项目的颜色',
        'light_mode' => '浅色模式',
        'dark_mode' => '深色模式',
    ],

    // Navigation Settings
    'navigation' => [
        'bottom_nav_bar' => '底部导航栏',
        'bottom_nav_bar_description' => '配置底部导航标签项（最多 8 项）',
        'add_item' => '+ 添加项目',
        'no_navigation_items' => '未配置导航项目',
        'add_first_navigation_item' => '添加您的第一个导航项目',
        'home_tab_badge' => '主页标签 - 与主 URL 同步',
        'home_item_badge' => '主页项目 - 与主 URL 同步',
        'label' => '标签',
        'label_placeholder_home' => '主页',
        'label_placeholder_about' => '关于我们',
        'action_type' => '操作类型',
        'action_internal' => '内部链接',
        'action_external' => '外部链接',
        'action_hosted_page' => '托管页面',
        'action_share' => '分享',
        'action_email' => '发送邮件',
        'action_call' => '拨打电话',
        'url' => 'URL',
        'email_address' => '邮箱地址',
        'phone_number' => '电话号码',
        'hosted_page' => '托管页面',
        'select_page' => '选择页面',
        'synced_from_general' => '自动从通用设置同步',
        'icon' => '图标',
        'select_icon' => '选择图标',
        'search_icons' => '搜索图标...',
        'home_tab_cannot_delete' => '主页标签无法删除',
        'home_item_cannot_delete' => '主页项目无法删除',
        'max_navigation_items' => '已达到最大 8 个导航项目（不含主页标签）',
        'app_bar_buttons' => '应用栏按钮',
        'app_bar_buttons_description' => '在应用栏右上角添加操作按钮（最多 3 个按钮）',
        'add_button' => '+ 添加按钮',
        'no_app_bar_buttons' => '未配置应用栏按钮',
        'add_first_app_bar_button' => '添加您的第一个应用栏按钮',
        'max_app_bar_buttons' => '已达到最大 3 个应用栏按钮',
        'drawer_menu_items' => '抽屉菜单项',
        'drawer_menu_items_description' => '配置导航抽屉菜单项（1 个主页 + 最多 9 个附加项目）',
        'no_drawer_items' => '未配置抽屉菜单项',
        'add_first_drawer_item' => '添加您的第一个抽屉菜单项',
        'max_drawer_items' => '已达到最大 9 个附加项目（共 10 个，含主页项目）',
        'behavior_settings' => '行为设置',
        'behavior_settings_description' => '配置用户交互',
        'pull_to_refresh' => '下拉刷新',
        'pull_to_refresh_description' => '允许用户通过下拉刷新内容',
        'swipe_navigation' => '滑动导航',
        'swipe_navigation_description' => '允许用户从边缘滑动返回',
        'swipe_navigation_disabled' => '抽屉布局已禁用以防止手势冲突',
        'preserve_tab_state' => '保持标签状态',
        'preserve_tab_state_description' => '在标签/抽屉项目之间切换时保持当前页面',
    ],

    // Sidebar
    'sidebar' => [
        'app_settings' => '应用设置',
        'general' => '通用',
        'design' => '设计',
        'icon' => '图标',
        'splashscreen' => '启动画面',
        'navigation' => '导航',
        'drawer' => '抽屉',
        'webview' => 'WebView',
        'permissions' => '权限',
        'custom_code' => '自定义代码',
        'hosted_pages' => '托管页面',
        'notifications' => '通知',
        'deployment' => '部署',
        'builds' => '构建',
        'signing' => '签名',
        'back_to_apps' => '返回应用列表',
    ],

    // WebView Settings
    'webview_user_agent_title' => '用户代理',
    'webview_user_agent_description' => '自定义浏览器用户代理字符串',
    'webview_custom_user_agent' => '自定义用户代理',
    'webview_user_agent_placeholder' => '留空则使用默认 Android WebView 用户代理',
    'webview_user_agent_helper' => '可选。覆盖发送到您网站的默认用户代理。',
    'webview_features_title' => 'WebView 功能',
    'webview_features_description' => '配置浏览器功能和行为',
    'webview_enable_javascript' => '启用 JavaScript',
    'webview_enable_javascript_description' => '允许在 WebView 中执行 JavaScript',
    'webview_enable_dom_storage' => '启用 DOM 存储',
    'webview_enable_dom_storage_description' => '允许 localStorage 和 sessionStorage API',
    'webview_enable_zoom_controls' => '启用缩放控制',
    'webview_enable_zoom_controls_description' => '允许双指缩放和缩放控制',
    'webview_enable_cache' => '启用缓存',
    'webview_enable_cache_description' => '缓存网页内容以加快加载速度',

    // Permissions Settings
    'permissions_location_title' => '位置权限',
    'permissions_location_description' => '访问设备 GPS 以实现基于位置的功能',
    'permissions_enable_location' => '启用位置访问',
    'permissions_location_helper' => '地图、基于位置的内容和地理围栏功能所需。',
    'permissions_show_code_example' => '显示代码示例',
    'permissions_hide_code_example' => '隐藏代码示例',
    'permissions_javascript_example' => 'JavaScript 示例：',
    'permissions_camera_title' => '相机权限',
    'permissions_camera_description' => '访问设备相机以拍摄照片和视频',
    'permissions_enable_camera' => '启用相机访问',
    'permissions_camera_helper' => '拍摄照片、扫描二维码和视频通话所需。',
    'permissions_storage_title' => '存储权限',
    'permissions_storage_description' => '访问设备存储以上传和下载文件',
    'permissions_enable_storage' => '启用存储访问',
    'permissions_storage_helper' => '文件上传、图片选择器和下载文件所需。',
    'permissions_microphone_title' => '麦克风权限',
    'permissions_microphone_description' => '访问设备麦克风以录制音频',
    'permissions_enable_microphone' => '启用麦克风访问',
    'permissions_microphone_helper' => '语音录制、音频通话和语音识别所需。',
    'permissions_contacts_title' => '联系人权限',
    'permissions_contacts_description' => '访问设备联系人以实现社交功能',
    'permissions_enable_contacts' => '启用联系人访问',
    'permissions_contacts_helper' => '联系人选择器、邀请功能和社交集成所需。',
    'permissions_vibrate_title' => '振动权限',
    'permissions_vibrate_description' => '访问设备振动马达以实现触觉反馈',
    'permissions_enable_vibrate' => '启用振动',
    'permissions_vibrate_helper' => '触觉反馈和通知振动所需。',

    // Custom Code Settings
    'custom_code_access_required_title' => '需要升级',
    'custom_code_access_required_description' => '您当前的套餐不包含自定义代码注入功能。升级以访问此功能并向您的应用添加自定义 CSS 和 JavaScript。',
    'custom_code_upgrade_plan' => '升级您的套餐',
    'custom_code_enable_feature' => '以启用此功能。',
    'custom_code_css_title' => '自定义 CSS',
    'custom_code_css_description' => '添加自定义样式以个性化您的应用外观',
    'custom_code_css_label' => 'CSS 代码',
    'custom_code_css_helper' => '最大 100KB。CSS 将注入到每个页面。',
    'custom_code_js_title' => '自定义 JavaScript',
    'custom_code_js_description' => '添加自定义脚本以扩展功能',
    'custom_code_js_label' => 'JavaScript 代码',
    'custom_code_js_helper' => '最大 100KB。JavaScript 将在 WebView 中执行。',

    // Notifications Settings
    'notifications_title' => '通知',
    'notifications_description' => '配置 Firebase 云消息（FCM）以发送通知',
    'notifications_enable' => '启用通知',
    'notifications_firebase_service_account' => 'Firebase 服务账户',
    'notifications_firebase_service_account_description' => '服务器用于通过 FCM API 发送通知',
    'notifications_firebase_help_text' => 'JSON 文件（最大 2MB）',
    'notifications_delete_firebase_credentials' => '删除 Firebase 凭据',
    'notifications_delete_firebase_credentials_confirm' => '您确定要删除 Firebase 凭据文件吗？',
    'notifications_google_services' => 'Google Services',
    'notifications_google_services_description' => 'Android 应用配置所需',
    'notifications_google_services_help_text' => 'JSON 文件（最大 1MB）',
    'notifications_delete_google_services' => '删除 Google Services 文件',
    'notifications_delete_google_services_confirm' => '您确定要删除 Google Services 文件吗？',

    // Signing Keys Settings
    'signing_keys' => [
        'android_keystores' => 'Android 密钥库',
        'generate_new' => '生成新的',
        'upload_existing' => '上传现有的',
        'default_badge' => '默认',
        'alias' => '别名',
        'alias_placeholder' => 'my-key-alias',
        'auto_generated' => '自动生成',
        'created' => '创建时间',
        'set_as_default' => '设为默认',
        'edit' => '编辑',
        'delete' => '删除',
        'no_keystores' => '还没有 Android 密钥库。生成新密钥或上传现有密钥。',
        'upload_signing_key' => '上传签名密钥',
        'android_keystore_upload' => 'Android 密钥库上传',
        'keystore_name' => '密钥库名称',
        'keystore_name_placeholder' => '我的发布密钥库',
        'keystore_file' => '密钥库文件',
        'keystore_file_help' => '.jks、.keystore 或 .ks 文件（最大 5MB）',
        'upload_custom_key' => '上传自定义密钥',
        'upload_custom_key_help' => '如果使用自动生成的调试密钥库，请取消选中此项',
        'password' => '密码',
        'password_placeholder' => '••••••••',
        'password_help' => '用于密钥库和密钥访问',
        'cancel' => '取消',
        'upload' => '上传',
        'edit_keystore' => '编辑密钥库',
        'update_password' => '更新密码',
        'save' => '保存',
        'delete_keystore' => '删除密钥库',
        'delete_confirmation' => '您确定要删除',
        'action_cannot_be_undone' => '此操作无法撤消。',

        // Keystore Generator Modal
        'generate_signing_key' => '生成签名密钥',
        'generate_android_keystore' => '生成 Android 密钥库',
        'generate_keystore_description' => '将在构建服务器上安全生成新的 JKS 密钥库',
        'keystore_name_generate_placeholder' => '我的应用发布密钥',
        'key_alias' => '密钥别名',
        'key_alias_placeholder' => 'my-app-key',
        'key_alias_help' => '必须以字母开头。允许使用字母、数字、连字符和下划线。',
        'password_settings' => '密码设置',
        'keystore_password' => '密钥库密码',
        'min_characters_placeholder' => '最少 6 个字符',
        'use_same_password' => '密钥和密钥库使用相同密码',
        'key_password' => '密钥密码',
        'validity_period' => '有效期',
        'years_10' => '10 年',
        'years_15' => '15 年',
        'years_20' => '20 年',
        'years_25_recommended' => '25 年（推荐）',
        'years_30' => '30 年',
        'validity_help' => 'Google Play 要求新应用至少 25 年有效期',
        'certificate_details' => '证书详情（可选）',
        'common_name' => '通用名称（CN）',
        'common_name_placeholder' => '您的应用或组织名称',
        'organization' => '组织（O）',
        'organization_placeholder' => '公司名称',
        'organizational_unit' => '组织单位（OU）',
        'organizational_unit_placeholder' => '移动应用',
        'city' => '城市（L）',
        'city_placeholder' => '上海',
        'state' => '省/州（ST）',
        'state_placeholder' => '上海',
        'country' => '国家（C）',
        'country_placeholder' => 'CN',
        'save_password_warning' => '重要：请妥善保存您的密码！',
        'save_password_description' => '密钥库将被加密存储。您将需要密码进行未来的构建。无法恢复丢失的密码。',
        'generating' => '生成中...',
        'generate_keystore' => '生成密钥库',
    ],

    // Hosted Pages Settings
    'hosted_pages' => [
        'access_required' => '需要托管页面访问权限',
        'upgrade_description' => '您当前的套餐不包含托管页面。升级您的套餐以创建由我们托管的自定义页面。',
        'upgrade_plan' => '升级您的套餐',
        'upgrade_suffix' => '以启用此功能。',
        'table_page' => '页面',
        'table_status' => '状态',
        'table_created' => '创建时间',
        'table_actions' => '操作',
        'status_published' => '已发布',
        'status_draft' => '草稿',
        'edit' => '编辑',
        'delete' => '删除',
        'no_pages' => '还没有页面',
        'no_pages_description' => '点击"添加页面"创建您的第一个托管页面。',
    ],

    // Hosted Page Editor Modal
    'hosted_page_editor' => [
        'create_page' => '创建页面',
        'edit_page' => '编辑页面',
        'title' => '标题',
        'title_placeholder' => '页面标题',
        'slug' => '别名',
        'slug_placeholder' => 'page-slug',
        'start_from_template' => '从模板开始',
        'status' => '状态',
        'status_help' => '只有已发布的页面可在应用中访问',
        'cancel' => '取消',
        'save_changes' => '保存更改',
    ],

    // WordPress-specific Settings
    'wordpress' => [
        // General Settings
        'app_name_placeholder' => '我的 WordPress 应用',
        'wordpress_site_url' => 'WordPress 站点 URL',
        'wordpress_site_url_placeholder' => 'https://myblog.wordpress.com',
        'wordpress_site_url_help' => '输入您的 WordPress.com 站点 URL（例如，myblog.wordpress.com）',
        'app_id_placeholder' => 'com.example.wordpress',
        'package_name_help' => '反向域名格式的唯一标识符（例如，com.company.wordpress）。创建后无法更改。',

        // Design Settings
        'post_list_style' => '文章列表样式',
        'style_list' => '列表',
        'style_grid' => '网格',
        'style_magazine' => '杂志',
        'post_list_style_help' => '应用中文章的显示方式',
        'progress_indicator_help' => '获取文章时显示的加载指示器样式',
        'show_app_bar_title' => '在应用栏中显示应用名称',
        'show_app_bar_title_help' => '在顶部栏中显示您的应用名称',
        'nav_tab_icon_colors_help' => '未激活标签图标的颜色',
        'active_tab_colors_help' => '选中标签的颜色',
        'theme_color_help' => '整个应用中使用的主要颜色（WordPress 蓝：#21759B）',
        'dynamic_colors_help' => '启用后，您的应用将在 Android 12+ 设备上根据用户壁纸调整颜色。',
        'layout_list_only' => '仅列表',

        // Splashscreen Settings
        'splashscreen_title_placeholder' => '我的 WordPress 应用',
        'splashscreen_subtitle_placeholder' => '欢迎使用最棒的博客应用',

        // Sidebar
        'content' => '内容',
        'features' => '功能',

        // Drawer Settings
        'drawer_appearance_description' => '自定义导航抽屉背景',
        'drawer_branding_description' => '徽标、标题和文字样式',
        'logo_light_mode' => '徽标（浅色模式）',
        'logo_dark_mode' => '徽标（深色模式）',
        'png_transparency_help' => '透明背景的 PNG（最大 2MB）',
        'delete_background' => '删除背景',
        'drawer_title_placeholder' => '我的 WordPress 应用',
        'drawer_subtitle_placeholder' => '您的标语在这里',
        'item_colors_description' => '菜单项的图标和文字颜色',
        'inactive_item_colors' => '未激活项目颜色',

        // Navigation Settings
        'bottom_nav_tabs' => '底部导航标签',
        'bottom_nav_tabs_description' => '配置底部导航项目（最多 8 个 + 主页）',
        'add_tab' => '+ 添加标签',
        'home_tab_shows_all_posts' => '主页标签 - 显示所有文章',
        'home_item_shows_all_posts' => '主页项目 - 显示所有文章',
        'tab_name_placeholder' => '标签名称',
        'menu_item_placeholder' => '菜单项',
        'action_category' => '分类',
        'action_tag' => '标签',
        'action_search' => '搜索',
        'action_bookmarks' => '书签',
        'action_share' => '分享',
        'category_slug' => '分类别名',
        'tag_slug' => '标签别名',
        'category_slug_placeholder' => 'technology',
        'tag_slug_placeholder' => 'featured',
        'app_bar_buttons_description' => '右上角的操作按钮（最多 3 个）',
        'no_app_bar_buttons_description' => '未配置应用栏按钮。添加搜索、分享或其他快捷操作。',
        'search_placeholder' => '搜索',
        'drawer_menu_items_description' => '导航抽屉菜单项（1 个主页 + 最多 9 个项目）',
        'swipe_navigation_description' => '从边缘滑动返回',
        'preserve_tab_state_description' => '切换标签时保持滚动位置',

        // Content Settings
        'post_display' => '文章显示',
        'post_display_description' => '配置应用中文章的显示方式',
        'posts_per_page' => '每页文章数',
        'posts_per_page_help' => '一次加载的文章数量（1-50）',
        'excerpt_length' => '摘要长度（字符）',
        'excerpt_length_help' => '文章摘要显示的最大字符数（50-500）',
        'post_metadata' => '文章元数据',
        'post_metadata_description' => '选择每篇文章显示哪些信息',
        'show_featured_image' => '显示特色图片',
        'show_featured_image_help' => '显示文章的特色/缩略图',
        'show_excerpt' => '显示文章摘要',
        'show_excerpt_help' => '显示文章内容的预览',
        'show_author' => '显示作者姓名',
        'show_author_help' => '显示撰写文章的作者',
        'show_date' => '显示发布日期',
        'show_date_help' => '显示文章发布时间',
        'show_categories' => '显示分类',
        'show_categories_help' => '显示分配给文章的分类',
        'show_reading_time' => '显示预计阅读时间',
        'show_reading_time_help' => '显示阅读文章所需的时间',

        // Features Settings
        'core_features' => '核心功能',
        'core_features_description' => '启用或禁用应用功能',
        'enable_search' => '启用搜索',
        'enable_search_help' => '允许用户在应用中搜索文章',
        'enable_comments' => '启用评论',
        'enable_comments_help' => '允许用户查看和发表文章评论',
        'enable_bookmarks' => '启用书签',
        'enable_bookmarks_help' => '允许用户保存文章以便稍后阅读',
        'enable_share' => '启用分享',
        'enable_share_help' => '允许用户通过其他应用分享文章',
        'advanced_features' => '高级功能',
        'advanced_features_description' => '增强用户体验的附加功能',
        'enable_offline_reading' => '启用离线阅读',
        'enable_offline_reading_help' => '缓存文章以便在没有网络连接时阅读',
        'enable_user_auth' => '启用用户认证',
        'enable_user_auth_help' => '允许用户使用其 WordPress.com 账户登录',
        'enable_push_notifications' => '启用推送通知',
        'enable_push_notifications_help' => '发布新文章时发送通知',
    ],

    // Builds
    'builds' => [
        // Builds Table
        'search_placeholder' => '搜索构建...',
        'filter' => '筛选',
        'platform_filter' => '平台',
        'status_filter' => '状态',
        'android' => 'Android',
        'completed' => '已完成',
        'building' => '构建中',
        'failed' => '失败',
        'pending' => '等待中',
        'table_platform' => '平台',
        'table_build_info' => '构建信息',
        'table_created' => '创建时间',
        'table_actions' => '操作',
        'release' => '发布',
        'debug' => '调试',
        'download' => '下载',
        'preview' => '预览',
        'logs' => '日志',
        'delete' => '删除',
        'no_builds' => '未找到构建',

        // Build Modal
        'create_new_build' => '创建新构建',
        'platform_label' => '平台',
        'build_costs_credit' => '构建消耗 :count 积分',
        'build_type_label' => '构建类型',
        'for_testing' => '用于测试',
        'for_production' => '用于生产',
        'output_format_label' => '输出格式',
        'apk' => 'APK',
        'aab' => 'AAB',
        'for_testing_sideloading' => '用于测试/侧载',
        'for_google_play_store' => '用于 Google Play 商店',
        'builder_label' => '构建器',
        'auto_select_recommended' => '自动选择（推荐）',
        'auto_select_help' => '保持"自动选择"以使用最空闲的构建器，或选择特定的构建器。',
        'no_builders_available' => '没有可用的构建器！',
        'no_builders_help' => '您的套餐无法访问任何构建器。请联系支持或升级您的套餐。',
        'signing_key_label' => '签名密钥',
        'select_keystore' => '选择密钥库',
        'no_keystores_available' => '没有可用的密钥库。',
        'upload_in_signing_section' => '在签名部分上传一个',
        'signing_key_required' => '需要签名密钥！',
        'version_name_label' => '版本名称',
        'version_name_help' => '格式：X.Y 或 X.Y.Z（例如，1.0 或 1.0.0）。每个平台自动递增。',
        'build_number_label' => '构建号',
        'next_build_number' => '下一个构建号',
        'build_number_auto_increment' => '构建号随每次构建自动递增',
        'build_cost_info' => '此构建将消耗 :count 积分',
        'build_email_notification' => '构建准备好下载时，您将收到电子邮件。',
        'cancel' => '取消',
        'start_build' => '开始构建',
        'credit' => '积分',
        'credits' => '积分',
        'builder_info' => '构建器：',

        // Build Logs Modal
        'build_logs' => '构建日志',
        'duration' => '时长：',
        'no_logs_available' => '此构建没有可用的日志',
        'error' => '错误：',
        'close' => '关闭',
        'download_build' => '下载构建',

        // Build Download Modal
        'download_build_title' => '下载构建',
        'aab_title' => 'Android 应用包（AAB）',
        'aab_description' => '这是一个 AAB 文件，无法直接安装在设备上。AAB 文件设计用于上传到 Google Play 控制台，Google 将为用户生成优化的 APK。',
        'scan_with_android' => '使用您的 Android 设备扫描',
        'qr_unavailable' => '二维码不可用',
        'download_options' => '下载选项',
        'download_options_description' => '使用您的移动设备扫描二维码或使用下面的直接下载链接。',
        'download_format' => '下载 :format',
        'installation_note' => '安装：',
        'installation_help' => '您可能需要在 Android 设置中启用"从未知来源安装"。',
        'download_aab_file' => '下载 AAB 文件',
        'upload_to_play_console' => '将此文件上传到 Google Play 控制台以发布您的应用。',
        'next_steps' => '后续步骤：',
        'next_steps_help' => '将此 AAB 文件上传到 Google Play 控制台的发布 > 正式版/测试版。Google 将自动为您的用户生成优化的 APK。',

        // Delete Build Modal
        'delete_build' => '删除构建',
        'delete_confirmation' => '您确定要删除',
        'build_suffix' => '构建吗？',
        'action_cannot_be_undone' => '此操作无法撤消。',
    ],

    // App Preview Panel
    'preview' => [
        'no_build_selected' => '未选择构建',
        'select_build_help' => '从构建标签中选择一个已完成的构建以在此预览',
    ],

    // App Creation Form
    'creation' => [
        'website_url' => '网站 URL',
        'app_id' => '应用 ID',
        'app_id_tooltip' => '唯一包标识符（创建后无法更改）',
        'auto_generate_package' => '从应用名称自动生成',
        'package_name_help' => '反向域名格式的唯一标识符（例如，com.company.app）。创建后无法更改。',
        'theme_color' => '主题颜色',
        'theme_color_help' => '整个应用中使用的主要颜色。文字颜色将使用默认黑色/白色，稍后可自定义。',
        'layout_template' => '布局模板',
        'layout_app_bar_drawer' => '应用栏 + 抽屉',
        'layout_app_bar_tabs' => '应用栏 + 导航标签',
        'layout_app_bar' => '应用栏',
        'layout_blank' => '空白',
        'layout_help' => '为您的应用选择导航结构',
    ],

    // Delete Modals
    'modals' => [
        'cancel' => '取消',
        'delete' => '删除',
        'action_cannot_be_undone' => '此操作无法撤消。',
        'delete_build' => '删除构建',
        'delete_build_confirmation' => '您确定要删除',
        'build_suffix' => '构建吗？',
        'delete_app_icon' => '删除应用图标',
        'delete_icon_confirmation' => '您确定要删除以下应用的图标吗',
        'delete_keystore' => '删除密钥库',
        'delete_keystore_confirmation' => '您确定要删除',
        'delete_splashscreen_background' => '删除启动画面背景',
        'delete_splashscreen_background_confirmation' => '您确定要删除以下应用的启动画面背景图片吗',
        'delete_splashscreen_logo' => '删除启动画面徽标',
        'delete_splashscreen_logo_confirmation' => '您确定要删除以下应用的启动画面徽标吗',
        'delete_drawer_background' => '删除抽屉背景',
        'delete_drawer_background_confirmation' => '您确定要删除以下应用的抽屉背景图片吗',
        'delete_dark_mode_logo' => '删除深色模式徽标',
        'delete_dark_mode_logo_confirmation' => '您确定要删除以下应用的抽屉深色模式徽标吗',
        'delete_light_mode_logo' => '删除浅色模式徽标',
        'delete_light_mode_logo_confirmation' => '您确定要删除以下应用的抽屉浅色模式徽标吗',
        'delete_page' => '删除页面',
        'delete_page_confirmation' => '您确定要删除',
        'delete_page_warning' => '此操作无法撤消。如果此页面在您的导航中使用，它将不再可访问。',
    ],

    // WordPress Notifications Settings
    'notifications_wp' => [
        'title' => '推送通知',
        'description' => '配置 Firebase 云消息以发送推送通知',
        'enable_label' => '启用推送通知',
        'enable_help' => '发布新文章时发送通知',
        'firebase_required_title' => '需要 Firebase 配置',
        'firebase_required_description' => '上传以下两个配置文件以在您的应用中启用推送通知。',
        'google_services_label' => 'google-services.json',
        'file_uploaded' => '文件已上传',
        'google_services_configured' => 'google-services.json 已配置',
        'delete' => '删除',
        'delete_file_confirm' => '您确定要删除此文件吗？',
        'upload_google_services' => '上传 google-services.json',
        'google_services_help' => '从 Firebase 控制台下载（最大 1MB）',
        'google_services_instructions' => '从 Firebase 控制台 > 项目设置 > 您的应用 > Android 应用 下载',
        'firebase_service_account_label' => 'Firebase 服务账户（用于发送通知）',
        'credentials_configured' => '凭据已配置',
        'service_account_stored' => '服务账户已安全存储',
        'delete_credentials_confirm' => '您确定要删除这些凭据吗？',
        'upload_service_account' => '上传服务账户 JSON',
        'service_account_help' => '从 Firebase 控制台下载（最大 2MB）',
        'service_account_instructions' => '从 Firebase 控制台 > 项目设置 > 服务账户 > 生成新的私钥 下载',
        'setup_title' => '如何设置 Firebase：',
        'setup_step_1' => '前往',
        'setup_step_2' => '创建项目或选择现有项目',
        'setup_step_3' => '使用您的包名添加 Android 应用：',
        'setup_step_4' => '下载',
        'setup_step_4_suffix' => '并在上面上传',
        'setup_step_5' => '前往项目设置 > 服务账户',
        'setup_step_6' => '生成新的私钥并在上面上传',
    ],

    // Toast Messages - Settings
    'toast' => [
        // General success/error
        'settings_saved' => ':section 设置保存成功！',
        'settings_save_failed' => '保存设置失败。请重试。',

        // Design settings
        'design_saved' => '设计设置保存成功！',

        // Navigation settings
        'navigation_saved' => '导航设置保存成功！',
        'home_tab_cannot_delete' => '主页标签无法删除。导航需要它。',
        'home_tab_cannot_move' => '主页标签必须保持第一位且无法移动。',
        'cannot_move_below_home' => '无法将项目移动到主页标签下方。',
        'home_item_cannot_delete' => '主页项目无法删除。导航需要它。',
        'home_item_cannot_move' => '主页项目必须保持第一位且无法移动。',
        'cannot_move_below_home_item' => '无法将项目移动到主页项目下方。',

        // Custom code
        'custom_code_saved' => '自定义代码保存成功！',
        'custom_code_save_failed' => '保存自定义代码失败。请重试。',
        'custom_code_no_access' => '您的套餐不包含自定义代码访问权限。请升级您的套餐。',

        // WebView settings
        'webview_saved' => 'WebView 设置保存成功！',

        // Permissions settings
        'permissions_saved' => '权限保存成功！',

        // Drawer settings
        'drawer_saved' => '抽屉设置保存成功！',

        // General settings
        'general_saved' => '通用设置保存成功！',

        // Splashscreen settings
        'splashscreen_saved' => '启动画面设置保存成功！',

        // Icon settings
        'icon_uploaded' => '应用图标上传成功！',
        'icon_upload_failed' => '上传图标失败：:error',
        'icon_removed' => '应用图标删除成功！',
        'icon_remove_failed' => '删除图标失败。请重试。',

        // Splashscreen modals
        'splashscreen_background_deleted' => '启动画面背景图片删除成功！',
        'splashscreen_background_delete_failed' => '删除背景图片失败。请重试。',
        'splashscreen_logo_deleted' => '启动画面徽标删除成功！',
        'splashscreen_logo_delete_failed' => '删除徽标失败。请重试。',

        // Drawer modals
        'drawer_background_deleted' => '抽屉背景图片删除成功！',
        'drawer_background_delete_failed' => '删除背景图片失败。请重试。',
        'drawer_logo_deleted' => '抽屉徽标删除成功！',
        'drawer_logo_delete_failed' => '删除徽标失败。请重试。',
        'drawer_logo_light_deleted' => '抽屉浅色模式徽标删除成功！',
        'drawer_logo_dark_deleted' => '抽屉深色模式徽标删除成功！',

        // Notifications settings
        'notifications_saved' => '通知设置保存成功！',
        'firebase_credentials_deleted' => 'Firebase 凭据删除成功！',
        'firebase_credentials_delete_failed' => '删除 Firebase 凭据失败。请重试。',
        'google_services_deleted' => 'Google Services 文件删除成功！',
        'google_services_delete_failed' => '删除 Google Services 文件失败。请重试。',

        // Signing keys
        'keystore_updated' => '密钥库更新成功！',
        'keystore_update_failed' => '更新密钥库失败。',
        'keystore_load_failed' => '加载密钥库失败。',
        'keystore_deleted' => '密钥库删除成功！',
        'keystore_delete_failed' => '删除密钥库失败。请重试。',
        'keystore_uploaded' => '密钥库上传成功！',
        'keystore_upload_failed' => '上传签名密钥失败：:error',
        'keystore_generated' => '密钥库生成成功！',
        'keystore_set_default' => '默认密钥库更新成功！',

        // Build modal
        'build_no_builders_platform' => '没有可用于 :platform 平台的构建器。请联系支持或升级您的套餐。',
        'build_no_subscription' => '您需要有效的订阅才能构建应用。请订阅套餐。',
        'build_no_builders_plan' => '您的套餐没有可用的构建器。请联系支持或升级您的套餐。',
        'build_builder_not_available' => '所选构建器不适用于您的套餐。',
        'build_builder_unavailable' => '所选构建器当前不可用。',
        'build_builder_no_platform' => '所选构建器不支持 :platform 平台。',
        'build_insufficient_credits' => '构建积分不足。此构建需要 :count 积分。请升级您的套餐或等待每月重置。',
        'build_keystore_required' => '发布构建需要 Android 密钥库。请选择一个密钥库。',
        'build_keystore_invalid' => '所选密钥库无效。',
        'build_already_in_progress' => ':platform 构建已在进行中。请等待完成。',
        'build_queued' => ':platform 构建已成功排队！当构建器可用时，您的构建将被处理。（剩余 :credits 积分）',
        'build_queued_on_builder' => ':platform 构建已成功在 :builder 上排队！（剩余 :credits 积分）',
        'build_create_failed' => '创建构建失败：:error',
        'build_deleted' => '构建删除成功！',
        'build_delete_failed' => '删除构建失败。请重试。',

        // Hosted pages
        'hosted_page_saved' => '页面保存成功！',
        'hosted_page_save_failed' => '保存页面失败。请重试。',
        'hosted_page_deleted' => '页面删除成功！',
        'hosted_page_delete_failed' => '删除页面失败。请重试。',
        'hosted_page_limit_reached' => '您已达到套餐的最大托管页面数量。',
        'hosted_page_no_access' => '您当前的套餐不包含托管页面。升级您的套餐以创建自定义页面。',

        // Additional toast keys for AndroidWordPress
        'features_saved' => '功能设置保存成功！',
        'content_saved' => '内容设置保存成功！',
        'storage_link_missing' => '未找到存储链接。运行：php artisan storage:link',
        'splashscreen_image_deleted' => '启动画面背景图片删除成功！',
        'splashscreen_image_delete_failed' => '删除背景图片失败。请重试。',
        'logo_delete_failed' => '删除徽标失败。请重试。',
        'default_key_updated' => '默认签名密钥更新成功！',
        'default_key_update_failed' => '更新默认签名密钥失败。',
        'keystore_uploaded_default' => '密钥库已上传并设为默认！',
        'signing_key_upload_failed' => '上传签名密钥失败：:error',
        'page_not_found' => '页面未找到。',
        'page_deleted' => '页面删除成功！',
        'page_delete_failed' => '删除页面失败。请重试。',
        'page_updated' => '页面更新成功！',
        'page_created' => '页面创建成功！',
        'page_save_failed' => '保存页面失败。请重试。',
        'page_limit_reached' => '您已达到套餐的最大页面数 :max。',
        'hosted_pages_not_available' => '您的套餐不包含托管页面。请升级您的套餐。',
        'unauthorized' => '未授权的操作。',
        'home_tab_required' => '主页标签无法删除。导航需要它。',
        'home_tab_first' => '主页标签必须保持第一位。',
        'home_item_required' => '主页项目无法删除。',
        'build_no_builders' => '没有可用于 :platform 平台的构建器。请联系支持或升级您的套餐。',
        'build_no_plan_builders' => '您的套餐没有可用的构建器。请联系支持或升级您的套餐。',
        'build_builder_platform_unsupported' => '所选构建器不支持 :platform 平台。',
        'build_insufficient_credits' => '构建积分不足。此构建需要 :credits 积分。请升级您的套餐或等待每月重置。',
        'build_invalid_keystore' => '所选密钥库无效。',
        'build_queued_no_builder' => ':platform 构建已成功排队！当构建器可用时，您的构建将被处理。（剩余 :credits 积分）',
        'build_queued_success' => ':platform 构建已成功在 :builder 上排队！（剩余 :credits 积分）',
        'available_builder' => '可用构建器',
        'invalid_google_services_json' => '无效的 JSON 文件。请上传有效的 google-services.json 文件。',
        'invalid_google_services_structure' => '无效的 google-services.json。缺少必需的 project_info 或 client 部分。',
        'invalid_firebase_service_account' => '无效的 JSON 文件。请上传有效的 Firebase 服务账户文件。',
        'invalid_firebase_service_account_type' => '无效的 Firebase 服务账户文件。缺少或无效的 type 字段。',
        'settings_save_failed_error' => '保存设置失败：:error',
        'file_delete_failed' => '删除文件失败：:error',
        'credentials_delete_failed' => '删除凭据失败：:error',
    ],

    // Editor Section Headers
    'sections' => [
        'general' => '通用',
        'general_description' => '基本信息和配置设置',
        'design' => '设计',
        'design_description' => '自定义布局、颜色和主题设置',
        'icon' => '图标',
        'icon_description' => '为 Android 上传应用图标',
        'splashscreen' => '启动画面',
        'splashscreen_description' => '配置启动画面外观和动画',
        'navigation' => '导航',
        'navigation_description' => '管理导航项目和应用栏按钮',
        'drawer' => '抽屉设置',
        'drawer_description' => '自定义抽屉菜单外观和品牌',
        'webview' => 'WebView 设置',
        'webview_description' => '配置 WebView 行为和功能',
        'permissions' => '权限',
        'permissions_description' => '配置您的应用将请求的设备权限',
        'custom_code' => '自定义代码',
        'custom_code_description' => '向您的应用注入自定义 CSS 和 JavaScript',
        'hosted_pages' => '托管页面',
        'hosted_pages_description' => '创建由我们托管的自定义 HTML 页面用于您的应用',
        'pages' => '页面',
        'add_page' => '添加页面',
        'notifications' => '通知',
        'notifications_description' => '配置 Firebase 云消息以发送通知',
        'builds' => '构建',
        'builds_description' => '生成用于部署的 Android APK 和 AAB 文件',
        'credits' => '积分',
        'new_build' => '新建构建',
        'signing' => '签名',
        'signing_description' => '管理用于应用分发的签名密钥',
        // WordPress-specific sections
        'general_description_wordpress' => '基本信息和 WordPress 站点配置',
        'content' => '内容',
        'content_description' => '配置文章显示和内容设置',
        'features' => '功能',
        'features_description' => '启用或禁用应用功能',
    ],

];
