<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Platform Plugin Translation Strings
    |--------------------------------------------------------------------------
    |
    | The following language lines are used by the platform plugin blade
    | templates for settings and configuration pages.
    |
    */

    // General Settings
    'general' => [
        'basic_information' => '基本情報',
        'basic_information_description' => 'アプリに関する基本的な詳細',
        'app_name' => 'アプリ名',
        'app_name_placeholder' => 'マイアプリ',
        'app_name_help' => 'デバイスのホーム画面に表示されます',
        'website_url' => 'ウェブサイトURL',
        'website_url_placeholder' => 'https://example.com',
        'website_url_help' => 'ウェブサイトまたはウェブアプリの完全なURL',
        'configuration' => '設定',
        'configuration_description' => '技術的な設定と識別子',
        'app_id' => 'アプリID',
        'app_id_tooltip' => 'アプリストアで使用される一意のパッケージ識別子',
        'app_id_placeholder' => 'com.example.app',
        'app_id_help' => 'アプリIDは作成後に変更できません',
        'copy' => 'コピー',
        'copied' => 'コピーしました！',
        'screen_orientation' => '画面の向き',
        'screen_orientation_help' => 'デバイスでのアプリの回転を制御',
        'orientation_system' => 'システム',
        'orientation_portrait' => '縦向き',
        'orientation_landscape' => '横向き',
        'app_language' => 'アプリ言語（ISOコード）',
        'app_language_help' => 'アプリコンテンツの主要言語',
    ],

    // Design Settings
    'design' => [
        'layout_template' => 'レイアウトテンプレート',
        'layout_template_description' => 'アプリのナビゲーション構造を選択',
        'layout_app_bar_drawer' => 'アプリバー + ドロワー',
        'layout_app_bar_tabs' => 'アプリバー + ナビゲーションタブ',
        'layout_app_bar' => 'アプリバー',
        'layout_blank' => 'ブランク',
        'progress_indicator' => 'プログレスインジケーター',
        'progress_indicator_help' => 'ページ読み込み時に表示されるローディングインジケーターのスタイル',
        'progress_disable' => '無効',
        'progress_linear' => 'リニア',
        'progress_circular' => 'サーキュラー',
        'progress_indicator_color' => 'プログレスインジケーターの色',
        'progress_indicator_color_help' => 'ローディングプログレスインジケーターの色',
        'show_app_bar_title' => 'アプリバーに現在のウェブページタイトルを表示',
        'show_app_bar_title_help' => '現在のページタイトルをトップバーに表示',
        'nav_tab_icon_colors' => 'ナビゲーションタブアイコンの色',
        'nav_tab_icon_colors_help' => 'ライトモードとダークモードでの非アクティブなタブアイコンの色',
        'active_tab_colors' => 'アクティブタブの色',
        'active_tab_colors_help' => 'ライトモードとダークモードでの選択されたタブの色',
        'light_mode' => 'ライトモード',
        'dark_mode' => 'ダークモード',
        'theme_colors' => 'テーマカラー',
        'theme_colors_description' => 'アプリの外観を定義する主要な色',
        'theme_color' => 'テーマカラー',
        'theme_color_help' => 'アプリ全体で使用されるメインカラー',
        'enable_dynamic_colors' => 'Material Youダイナミックカラーを有効化（Android 12+）',
        'enable_dynamic_colors_help' => '有効にすると、Android 12以上のデバイスでユーザーの壁紙から色を適用します。上記のテーマカラーを上書きします。',
        'text_color_light' => 'テキストカラー（ライトモード）',
        'text_color_light_help' => 'ライトモードでのデフォルトのテキストとアイコンの色',
        'text_color_dark' => 'テキストカラー（ダークモード）',
        'text_color_dark_help' => 'ダークモードでのデフォルトのテキストとアイコンの色',
    ],

    // Icon Settings
    'icon' => [
        'app_icon' => 'アプリアイコン',
        'app_icon_description' => 'icon.kitchenからのZIPファイルとしてアプリアイコンをアップロード',
        'current_icon' => '現在のアイコン',
        'icon_zip_uploaded' => 'アイコンZIPがアップロードされました',
        'icon_zip_uploaded_description' => '抽出されたアイコンはAndroidとWebプラットフォームで利用可能',
        'default_icon' => 'デフォルトアイコン',
        'default_icon_description' => 'カスタムアイコンをアップロードしてデフォルトを置き換え',
        'delete' => '削除',
        'upload_zip_file' => 'ZIPファイルをアップロード',
        'upload_zip_help' => 'icon.kitchenからのZIPファイル（最大10MB）',
        'how_to_create' => 'アイコンの作成方法：',
        'step_visit' => 'アクセス：',
        'step_design' => 'アプリアイコンをデザイン',
        'step_download' => 'すべてのプラットフォームアイコンを含むZIPファイルをダウンロード',
        'step_upload' => 'ここにZIPファイルをアップロード',
        'zip_file_info' => 'ZIPファイルにはAndroidとWebプラットフォーム用のアイコンが含まれている必要があります（最大10MB）',
        'upload_icon' => 'アイコンをアップロード',
    ],

    // Splashscreen Settings
    'splashscreen' => [
        'appearance' => 'スプラッシュスクリーンの外観',
        'appearance_description' => '背景、表示時間、アニメーション効果をカスタマイズ',
        'background_type' => '背景タイプ',
        'background_type_color' => '単色',
        'background_type_image' => '背景画像',
        'background_color' => '背景色',
        'background_image' => '背景画像',
        'background_image_help' => 'PNGのみ（最大2MB）',
        'delete_background_image' => '背景画像を削除',
        'display_duration' => '表示時間：',
        'seconds' => '秒',
        'animation_effect' => 'アニメーション効果',
        'animation_fade' => 'フェード',
        'animation_slide' => 'スライド',
        'animation_zoom' => 'ズーム',
        'animation_none' => 'なし',
        'branding' => 'スプラッシュスクリーンブランディング',
        'branding_description' => 'スプラッシュスクリーンにロゴ、タイトル、サブタイトル、テキストスタイルを追加',
        'show_logo' => 'スプラッシュスクリーンにロゴを表示',
        'logo_image' => 'ロゴ画像',
        'logo_image_help' => '透過PNGを推奨（最大2MB）',
        'delete_logo' => 'ロゴを削除',
        'logo_size' => 'ロゴサイズ：',
        'logo_size_small' => '小（60dp）',
        'logo_size_medium' => '中（150dp）',
        'logo_size_large' => '大（240dp）',
        'logo_size_help' => '最適な外観になるようロゴサイズを調整',
        'title' => 'タイトル',
        'title_placeholder' => 'マイアプリ',
        'subtitle' => 'サブタイトル',
        'subtitle_placeholder' => '最高のアプリへようこそ',
        'text_theme' => 'テキストテーマ',
        'text_theme_light' => 'ライト（白文字）',
        'text_theme_dark' => 'ダーク（黒文字）',
    ],

    // Drawer Settings
    'drawer' => [
        'appearance' => 'ドロワーの外観',
        'appearance_description' => 'ナビゲーションドロワーの背景とビジュアルスタイルをカスタマイズ',
        'drawer_mode' => 'ドロワーモード',
        'drawer_mode_help' => 'ドロワー背景の表示方法を選択',
        'mode_default' => 'デフォルト（テーマカラー）',
        'mode_color' => 'カスタムカラー',
        'mode_image' => '背景画像',
        'background_color' => '背景色',
        'background_color_help' => 'ドロワーのカスタム背景色',
        'background_image' => '背景画像',
        'background_image_help' => 'PNGのみ（最大2MB）。推奨：1080x1920px',
        'delete_background_image' => '背景画像を削除',
        'branding' => 'ドロワーブランディング',
        'branding_description' => 'ドロワーヘッダーにロゴ、タイトル、テキストの外観を追加',
        'show_logo' => 'ドロワーにロゴを表示',
        'show_logo_help' => 'ドロワーヘッダーにロゴを表示',
        'logo_light' => 'ドロワーロゴ（ライトモード）',
        'logo_light_help' => '透過PNG必須（最大2MB） - アプリがライトテーマの時に表示',
        'delete_light_logo' => 'ライトロゴを削除',
        'logo_dark' => 'ドロワーロゴ（ダークモード）',
        'logo_dark_help' => '透過PNG必須（最大2MB） - アプリがダークテーマの時に表示',
        'delete_dark_logo' => 'ダークロゴを削除',
        'logo_size' => 'ロゴサイズ：',
        'logo_size_small' => '小（40dp）',
        'logo_size_medium' => '中（120dp）',
        'logo_size_large' => '大（200dp）',
        'logo_size_help' => '最適な外観になるようロゴサイズを調整',
        'drawer_title' => 'ドロワータイトル',
        'drawer_title_placeholder' => 'マイアプリ',
        'drawer_title_help' => 'ドロワーヘッダーに表示されるタイトル',
        'drawer_subtitle' => 'ドロワーサブタイトル',
        'drawer_subtitle_placeholder' => 'マイアプリへようこそ',
        'drawer_subtitle_help' => 'タイトルの下に表示されるサブタイトルまたはタグライン',
        'text_theme' => 'テキストテーマ',
        'text_theme_help' => 'ドロワーヘッダーとメニュー項目のテキスト色',
        'text_theme_light' => 'ライト（白文字）',
        'text_theme_dark' => 'ダーク（黒文字）',
        'item_colors' => 'ドロワーアイテムの色',
        'item_colors_description' => 'ドロワーメニュー項目のアイコンとテキストの色をカスタマイズ',
        'item_icon_colors' => 'ドロワーアイテムアイコンの色',
        'item_icon_colors_help' => 'ライトモードとダークモードでの非アクティブなドロワー項目のアイコンとテキストの色',
        'active_item_colors' => 'アクティブアイテムの色',
        'active_item_colors_help' => 'ライトモードとダークモードでの選択されたドロワー項目の色',
        'light_mode' => 'ライトモード',
        'dark_mode' => 'ダークモード',
    ],

    // Navigation Settings
    'navigation' => [
        'bottom_nav_bar' => 'ボトムナビゲーションバー',
        'bottom_nav_bar_description' => 'ボトムナビゲーションタブ項目を設定（最大8項目）',
        'add_item' => '+ 項目を追加',
        'no_navigation_items' => 'ナビゲーション項目が設定されていません',
        'add_first_navigation_item' => '最初のナビゲーション項目を追加',
        'home_tab_badge' => 'ホームタブ - メインURLに同期',
        'home_item_badge' => 'ホーム項目 - メインURLに同期',
        'label' => 'ラベル',
        'label_placeholder_home' => 'ホーム',
        'label_placeholder_about' => '会社概要',
        'action_type' => 'アクションタイプ',
        'action_internal' => '内部リンク',
        'action_external' => '外部リンク',
        'action_hosted_page' => 'ホステッドページ',
        'action_share' => '共有',
        'action_email' => 'メール送信',
        'action_call' => '電話発信',
        'url' => 'URL',
        'email_address' => 'メールアドレス',
        'phone_number' => '電話番号',
        'hosted_page' => 'ホステッドページ',
        'select_page' => 'ページを選択',
        'synced_from_general' => '一般設定から自動同期',
        'icon' => 'アイコン',
        'select_icon' => 'アイコンを選択',
        'search_icons' => 'アイコンを検索...',
        'home_tab_cannot_delete' => 'ホームタブは削除できません',
        'home_item_cannot_delete' => 'ホーム項目は削除できません',
        'max_navigation_items' => 'ナビゲーション項目は最大8個です（ホームタブを除く）',
        'app_bar_buttons' => 'アプリバーボタン',
        'app_bar_buttons_description' => 'アプリバーの右上にアクションボタンを追加（最大3ボタン）',
        'add_button' => '+ ボタンを追加',
        'no_app_bar_buttons' => 'アプリバーボタンが設定されていません',
        'add_first_app_bar_button' => '最初のアプリバーボタンを追加',
        'max_app_bar_buttons' => 'アプリバーボタンは最大3個です',
        'drawer_menu_items' => 'ドロワーメニュー項目',
        'drawer_menu_items_description' => 'ナビゲーションドロワーメニュー項目を設定（ホーム1つ + 追加9項目まで）',
        'no_drawer_items' => 'ドロワーメニュー項目が設定されていません',
        'add_first_drawer_item' => '最初のドロワーメニュー項目を追加',
        'max_drawer_items' => '追加項目は最大9個です（ホーム項目を含めて合計10個）',
        'behavior_settings' => '動作設定',
        'behavior_settings_description' => 'ユーザーインタラクションを設定',
        'pull_to_refresh' => 'プルして更新',
        'pull_to_refresh_description' => 'ユーザーが下にプルしてコンテンツを更新可能に',
        'swipe_navigation' => 'スワイプナビゲーション',
        'swipe_navigation_description' => 'ユーザーがエッジからスワイプして戻ることを許可',
        'swipe_navigation_disabled' => 'ジェスチャーの競合を防ぐため、ドロワーレイアウトでは無効',
        'preserve_tab_state' => 'タブ状態を保持',
        'preserve_tab_state_description' => 'タブ/ドロワー項目を切り替えても現在のページを維持',
    ],

    // Sidebar
    'sidebar' => [
        'app_settings' => 'アプリ設定',
        'general' => '一般',
        'design' => 'デザイン',
        'icon' => 'アイコン',
        'splashscreen' => 'スプラッシュスクリーン',
        'navigation' => 'ナビゲーション',
        'drawer' => 'ドロワー',
        'webview' => 'WebView',
        'permissions' => '権限',
        'custom_code' => 'カスタムコード',
        'hosted_pages' => 'ホステッドページ',
        'notifications' => '通知',
        'deployment' => 'デプロイメント',
        'builds' => 'ビルド',
        'signing' => '署名',
        'back_to_apps' => 'アプリに戻る',
    ],

    // WebView Settings
    'webview_user_agent_title' => 'ユーザーエージェント',
    'webview_user_agent_description' => 'ブラウザのユーザーエージェント文字列をカスタマイズ',
    'webview_custom_user_agent' => 'カスタムユーザーエージェント',
    'webview_user_agent_placeholder' => 'デフォルトのAndroid WebViewユーザーエージェントを使用する場合は空白のまま',
    'webview_user_agent_helper' => '任意。ウェブサイトに送信されるデフォルトのユーザーエージェントを上書きします。',
    'webview_features_title' => 'WebView機能',
    'webview_features_description' => 'ブラウザの機能と動作を設定',
    'webview_enable_javascript' => 'JavaScriptを有効化',
    'webview_enable_javascript_description' => 'WebViewでのJavaScript実行を許可',
    'webview_enable_dom_storage' => 'DOMストレージを有効化',
    'webview_enable_dom_storage_description' => 'localStorageとsessionStorage APIを許可',
    'webview_enable_zoom_controls' => 'ズームコントロールを有効化',
    'webview_enable_zoom_controls_description' => 'ピンチズームとズームコントロールを許可',
    'webview_enable_cache' => 'キャッシュを有効化',
    'webview_enable_cache_description' => 'ウェブコンテンツをキャッシュして高速読み込み',

    // Permissions Settings
    'permissions_location_title' => '位置情報権限',
    'permissions_location_description' => '位置情報ベースの機能用にデバイスGPSにアクセス',
    'permissions_enable_location' => '位置情報アクセスを有効化',
    'permissions_location_helper' => 'マップ、位置情報ベースのコンテンツ、ジオフェンシング機能に必要です。',
    'permissions_show_code_example' => 'コード例を表示',
    'permissions_hide_code_example' => 'コード例を非表示',
    'permissions_javascript_example' => 'JavaScriptの例：',
    'permissions_camera_title' => 'カメラ権限',
    'permissions_camera_description' => '写真とビデオ用にデバイスカメラにアクセス',
    'permissions_enable_camera' => 'カメラアクセスを有効化',
    'permissions_camera_helper' => '写真撮影、QRコードスキャン、ビデオ通話に必要です。',
    'permissions_storage_title' => 'ストレージ権限',
    'permissions_storage_description' => 'ファイルのアップロードとダウンロード用にデバイスストレージにアクセス',
    'permissions_enable_storage' => 'ストレージアクセスを有効化',
    'permissions_storage_helper' => 'ファイルアップロード、画像ピッカー、ファイルダウンロードに必要です。',
    'permissions_microphone_title' => 'マイク権限',
    'permissions_microphone_description' => 'オーディオ録音用にデバイスマイクにアクセス',
    'permissions_enable_microphone' => 'マイクアクセスを有効化',
    'permissions_microphone_helper' => '音声録音、オーディオ通話、音声認識に必要です。',
    'permissions_contacts_title' => '連絡先権限',
    'permissions_contacts_description' => 'ソーシャル機能用にデバイスの連絡先にアクセス',
    'permissions_enable_contacts' => '連絡先アクセスを有効化',
    'permissions_contacts_helper' => '連絡先ピッカー、招待機能、ソーシャル統合に必要です。',
    'permissions_vibrate_title' => 'バイブレーション権限',
    'permissions_vibrate_description' => '触覚フィードバック用にデバイスのバイブレーションモーターにアクセス',
    'permissions_enable_vibrate' => 'バイブレーションを有効化',
    'permissions_vibrate_helper' => '触覚フィードバックと通知バイブレーションに必要です。',

    // Custom Code Settings
    'custom_code_access_required_title' => 'アップグレードが必要',
    'custom_code_access_required_description' => '現在のプランにはカスタムコード挿入が含まれていません。アップグレードしてこの機能にアクセスし、アプリにカスタムCSSとJavaScriptを追加してください。',
    'custom_code_upgrade_plan' => 'プランをアップグレード',
    'custom_code_enable_feature' => 'してこの機能を有効にしてください。',
    'custom_code_css_title' => 'カスタムCSS',
    'custom_code_css_description' => 'カスタムスタイルを追加してアプリの外観をパーソナライズ',
    'custom_code_css_label' => 'CSSコード',
    'custom_code_css_helper' => '最大100KB。CSSはすべてのページに挿入されます。',
    'custom_code_js_title' => 'カスタムJavaScript',
    'custom_code_js_description' => '拡張機能用のカスタムスクリプトを追加',
    'custom_code_js_label' => 'JavaScriptコード',
    'custom_code_js_helper' => '最大100KB。JavaScriptはWebView内で実行されます。',

    // Notifications Settings
    'notifications_title' => '通知',
    'notifications_description' => '通知用にFirebase Cloud Messaging（FCM）を設定',
    'notifications_enable' => '通知を有効化',
    'notifications_firebase_service_account' => 'Firebaseサービスアカウント',
    'notifications_firebase_service_account_description' => 'FCM APIを通じて通知を送信するためにサーバーが使用',
    'notifications_firebase_help_text' => 'JSONファイル（最大2MB）',
    'notifications_delete_firebase_credentials' => 'Firebase認証情報を削除',
    'notifications_delete_firebase_credentials_confirm' => 'Firebase認証情報ファイルを削除しますか？',
    'notifications_google_services' => 'Googleサービス',
    'notifications_google_services_description' => 'Androidアプリ設定に必要',
    'notifications_google_services_help_text' => 'JSONファイル（最大1MB）',
    'notifications_delete_google_services' => 'Googleサービスファイルを削除',
    'notifications_delete_google_services_confirm' => 'Googleサービスファイルを削除しますか？',

    // Signing Keys Settings
    'signing_keys' => [
        'android_keystores' => 'Androidキーストア',
        'generate_new' => '新規生成',
        'upload_existing' => '既存をアップロード',
        'default_badge' => 'デフォルト',
        'alias' => 'エイリアス',
        'alias_placeholder' => 'my-key-alias',
        'auto_generated' => '自動生成',
        'created' => '作成日',
        'set_as_default' => 'デフォルトに設定',
        'edit' => '編集',
        'delete' => '削除',
        'no_keystores' => 'Androidキーストアがまだありません。新しいキーを生成するか、既存のキーをアップロードしてください。',
        'upload_signing_key' => '署名キーをアップロード',
        'android_keystore_upload' => 'Androidキーストアアップロード',
        'keystore_name' => 'キーストア名',
        'keystore_name_placeholder' => 'リリースキーストア',
        'keystore_file' => 'キーストアファイル',
        'keystore_file_help' => '.jks、.keystore、または.ksファイル（最大5MB）',
        'upload_custom_key' => 'カスタムキーをアップロード',
        'upload_custom_key_help' => '自動生成のデバッグキーストアを使用する場合はチェックを外す',
        'password' => 'パスワード',
        'password_placeholder' => '••••••••',
        'password_help' => 'キーストアとキーアクセス両方に使用',
        'cancel' => 'キャンセル',
        'upload' => 'アップロード',
        'edit_keystore' => 'キーストアを編集',
        'update_password' => 'パスワードを更新',
        'save' => '保存',
        'delete_keystore' => 'キーストアを削除',
        'delete_confirmation' => '本当に削除しますか',
        'action_cannot_be_undone' => 'この操作は元に戻せません。',

        // Keystore Generator Modal
        'generate_signing_key' => '署名キーを生成',
        'generate_android_keystore' => 'Androidキーストアを生成',
        'generate_keystore_description' => '新しいJKSキーストアがビルドサーバーで安全に生成されます',
        'keystore_name_generate_placeholder' => 'マイアプリリリースキー',
        'key_alias' => 'キーエイリアス',
        'key_alias_placeholder' => 'my-app-key',
        'key_alias_help' => '文字で始める必要があります。文字、数字、ハイフン、アンダースコアが使用可能。',
        'password_settings' => 'パスワード設定',
        'keystore_password' => 'キーストアパスワード',
        'min_characters_placeholder' => '最低6文字',
        'use_same_password' => 'キーとキーストアに同じパスワードを使用',
        'key_password' => 'キーパスワード',
        'validity_period' => '有効期間',
        'years_10' => '10年',
        'years_15' => '15年',
        'years_20' => '20年',
        'years_25_recommended' => '25年（推奨）',
        'years_30' => '30年',
        'validity_help' => 'Google Playは新しいアプリに最低25年の有効期間を要求',
        'certificate_details' => '証明書詳細（任意）',
        'common_name' => 'コモンネーム（CN）',
        'common_name_placeholder' => 'アプリまたは組織名',
        'organization' => '組織（O）',
        'organization_placeholder' => '会社名',
        'organizational_unit' => '組織単位（OU）',
        'organizational_unit_placeholder' => 'モバイルアプリ',
        'city' => '都市（L）',
        'city_placeholder' => '東京',
        'state' => '都道府県（ST）',
        'state_placeholder' => '東京都',
        'country' => '国（C）',
        'country_placeholder' => 'JP',
        'save_password_warning' => '重要：パスワードを安全に保存してください！',
        'save_password_description' => 'キーストアは暗号化されて保存されます。将来のビルドにはパスワードが必要です。パスワードを紛失した場合、回復する方法はありません。',
        'generating' => '生成中...',
        'generate_keystore' => 'キーストアを生成',
    ],

    // Hosted Pages Settings
    'hosted_pages' => [
        'access_required' => 'ホステッドページへのアクセスが必要',
        'upgrade_description' => '現在のプランにはホステッドページが含まれていません。プランをアップグレードして、弊社でホストされるカスタムページを作成してください。',
        'upgrade_plan' => 'プランをアップグレード',
        'upgrade_suffix' => 'してこの機能を有効にしてください。',
        'table_page' => 'ページ',
        'table_status' => 'ステータス',
        'table_created' => '作成日',
        'table_actions' => 'アクション',
        'status_published' => '公開済み',
        'status_draft' => '下書き',
        'edit' => '編集',
        'delete' => '削除',
        'no_pages' => 'まだページがありません',
        'no_pages_description' => '「ページを追加」をクリックして最初のホステッドページを作成してください。',
    ],

    // Hosted Page Editor Modal
    'hosted_page_editor' => [
        'create_page' => 'ページを作成',
        'edit_page' => 'ページを編集',
        'title' => 'タイトル',
        'title_placeholder' => 'ページタイトル',
        'slug' => 'スラッグ',
        'slug_placeholder' => 'page-slug',
        'start_from_template' => 'テンプレートから開始',
        'status' => 'ステータス',
        'status_help' => '公開済みのページのみアプリでアクセス可能',
        'cancel' => 'キャンセル',
        'save_changes' => '変更を保存',
    ],

    // WordPress-specific Settings
    'wordpress' => [
        // General Settings
        'app_name_placeholder' => 'WordPressアプリ',
        'wordpress_site_url' => 'WordPressサイトURL',
        'wordpress_site_url_placeholder' => 'https://myblog.wordpress.com',
        'wordpress_site_url_help' => 'WordPress.comサイトURLを入力（例：myblog.wordpress.com）',
        'app_id_placeholder' => 'com.example.wordpress',
        'package_name_help' => '逆ドメイン形式の一意識別子（例：com.company.wordpress）。作成後は変更不可。',

        // Design Settings
        'post_list_style' => '記事リストスタイル',
        'style_list' => 'リスト',
        'style_grid' => 'グリッド',
        'style_magazine' => 'マガジン',
        'post_list_style_help' => 'アプリでの記事の表示方法',
        'progress_indicator_help' => '記事取得時に表示されるローディングインジケーターのスタイル',
        'show_app_bar_title' => 'アプリバーにアプリ名を表示',
        'show_app_bar_title_help' => 'トップバーにアプリ名を表示',
        'nav_tab_icon_colors_help' => '非アクティブなタブアイコンの色',
        'active_tab_colors_help' => '選択されたタブの色',
        'theme_color_help' => 'アプリ全体で使用されるメインカラー（WordPressブルー：#21759B）',
        'dynamic_colors_help' => '有効にすると、Android 12以上のデバイスでユーザーの壁紙から色を適用します。',
        'layout_list_only' => 'リストのみ',

        // Splashscreen Settings
        'splashscreen_title_placeholder' => 'WordPressアプリ',
        'splashscreen_subtitle_placeholder' => '最高のブログアプリへようこそ',

        // Sidebar
        'content' => 'コンテンツ',
        'features' => '機能',

        // Drawer Settings
        'drawer_appearance_description' => 'ナビゲーションドロワーの背景をカスタマイズ',
        'drawer_branding_description' => 'ロゴ、タイトル、テキストスタイル',
        'logo_light_mode' => 'ロゴ（ライトモード）',
        'logo_dark_mode' => 'ロゴ（ダークモード）',
        'png_transparency_help' => '透過PNG（最大2MB）',
        'delete_background' => '背景を削除',
        'drawer_title_placeholder' => 'WordPressアプリ',
        'drawer_subtitle_placeholder' => 'タグラインはこちら',
        'item_colors_description' => 'メニュー項目のアイコンとテキストの色',
        'inactive_item_colors' => '非アクティブ項目の色',

        // Navigation Settings
        'bottom_nav_tabs' => 'ボトムナビゲーションタブ',
        'bottom_nav_tabs_description' => 'ボトムナビゲーション項目を設定（最大8 + ホーム）',
        'add_tab' => '+ タブを追加',
        'home_tab_shows_all_posts' => 'ホームタブ - すべての記事を表示',
        'home_item_shows_all_posts' => 'ホーム項目 - すべての記事を表示',
        'tab_name_placeholder' => 'タブ名',
        'menu_item_placeholder' => 'メニュー項目',
        'action_category' => 'カテゴリー',
        'action_tag' => 'タグ',
        'action_search' => '検索',
        'action_bookmarks' => 'ブックマーク',
        'action_share' => '共有',
        'category_slug' => 'カテゴリースラッグ',
        'tag_slug' => 'タグスラッグ',
        'category_slug_placeholder' => 'technology',
        'tag_slug_placeholder' => 'featured',
        'app_bar_buttons_description' => '右上のアクションボタン（最大3個）',
        'no_app_bar_buttons_description' => 'アプリバーボタンが設定されていません。検索、共有、その他のクイックアクションを追加してください。',
        'search_placeholder' => '検索',
        'drawer_menu_items_description' => 'ナビゲーションドロワーメニュー項目（ホーム1つ + 最大9項目）',
        'swipe_navigation_description' => 'エッジからスワイプして戻る',
        'preserve_tab_state_description' => 'タブ切り替え時にスクロール位置を維持',

        // Content Settings
        'post_display' => '記事表示',
        'post_display_description' => 'アプリでの記事表示方法を設定',
        'posts_per_page' => '1ページあたりの記事数',
        'posts_per_page_help' => '一度に読み込む記事数（1〜50）',
        'excerpt_length' => '抜粋の長さ（文字数）',
        'excerpt_length_help' => '記事抜粋に表示される最大文字数（50〜500）',
        'post_metadata' => '記事メタデータ',
        'post_metadata_description' => '各記事に表示する情報を選択',
        'show_featured_image' => 'アイキャッチ画像を表示',
        'show_featured_image_help' => '記事のアイキャッチ/サムネイル画像を表示',
        'show_excerpt' => '記事抜粋を表示',
        'show_excerpt_help' => '記事コンテンツのプレビューを表示',
        'show_author' => '著者名を表示',
        'show_author_help' => '記事を書いた著者を表示',
        'show_date' => '公開日を表示',
        'show_date_help' => '記事が公開された日時を表示',
        'show_categories' => 'カテゴリーを表示',
        'show_categories_help' => '記事に割り当てられたカテゴリーを表示',
        'show_reading_time' => '推定読了時間を表示',
        'show_reading_time_help' => '記事を読むのにかかる時間を表示',

        // Features Settings
        'core_features' => 'コア機能',
        'core_features_description' => 'アプリ機能の有効/無効を切り替え',
        'enable_search' => '検索を有効化',
        'enable_search_help' => 'ユーザーがアプリ内で記事を検索可能に',
        'enable_comments' => 'コメントを有効化',
        'enable_comments_help' => 'ユーザーが記事のコメントを表示・投稿可能に',
        'enable_bookmarks' => 'ブックマークを有効化',
        'enable_bookmarks_help' => 'ユーザーが後で読むために記事を保存可能に',
        'enable_share' => '共有を有効化',
        'enable_share_help' => 'ユーザーが他のアプリで記事を共有可能に',
        'advanced_features' => '高度な機能',
        'advanced_features_description' => 'より良いユーザー体験のための追加機能',
        'enable_offline_reading' => 'オフライン読書を有効化',
        'enable_offline_reading_help' => 'インターネット接続なしで読むために記事をキャッシュ',
        'enable_user_auth' => 'ユーザー認証を有効化',
        'enable_user_auth_help' => 'ユーザーがWordPress.comアカウントでサインイン可能に',
        'enable_push_notifications' => 'プッシュ通知を有効化',
        'enable_push_notifications_help' => '新しい記事が公開されたときに通知を送信',
    ],

    // Builds
    'builds' => [
        // Builds Table
        'search_placeholder' => 'ビルドを検索...',
        'filter' => 'フィルター',
        'platform_filter' => 'プラットフォーム',
        'status_filter' => 'ステータス',
        'android' => 'Android',
        'completed' => '完了',
        'building' => 'ビルド中',
        'failed' => '失敗',
        'pending' => '保留中',
        'table_platform' => 'プラットフォーム',
        'table_build_info' => 'ビルド情報',
        'table_created' => '作成日',
        'table_actions' => 'アクション',
        'release' => 'リリース',
        'debug' => 'デバッグ',
        'download' => 'ダウンロード',
        'preview' => 'プレビュー',
        'logs' => 'ログ',
        'delete' => '削除',
        'no_builds' => 'ビルドが見つかりません',

        // Build Modal
        'create_new_build' => '新しいビルドを作成',
        'platform_label' => 'プラットフォーム',
        'build_costs_credit' => 'ビルドには:countクレジットかかります',
        'build_type_label' => 'ビルドタイプ',
        'for_testing' => 'テスト用',
        'for_production' => '本番用',
        'output_format_label' => '出力形式',
        'apk' => 'APK',
        'aab' => 'AAB',
        'for_testing_sideloading' => 'テスト/サイドローディング用',
        'for_google_play_store' => 'Google Play Store用',
        'builder_label' => 'ビルダー',
        'auto_select_recommended' => '自動選択（推奨）',
        'auto_select_help' => '最も空いているビルダーを使用するには「自動選択」のままにするか、特定のビルダーを選択してください。',
        'no_builders_available' => '利用可能なビルダーがありません！',
        'no_builders_help' => 'お使いのプランにはビルダーへのアクセスがありません。サポートに連絡するか、プランをアップグレードしてください。',
        'signing_key_label' => '署名キー',
        'select_keystore' => 'キーストアを選択',
        'no_keystores_available' => '利用可能なキーストアがありません。',
        'upload_in_signing_section' => '署名セクションでアップロードしてください',
        'signing_key_required' => '署名キーが必要です！',
        'version_name_label' => 'バージョン名',
        'version_name_help' => '形式：X.YまたはX.Y.Z（例：1.0または1.0.0）。プラットフォームごとに自動インクリメント。',
        'build_number_label' => 'ビルド番号',
        'next_build_number' => '次のビルド番号',
        'build_number_auto_increment' => 'ビルド番号はビルドごとに自動インクリメント',
        'build_cost_info' => 'このビルドには:countクレジットかかります',
        'build_email_notification' => 'ビルドがダウンロード可能になったらメールで通知します。',
        'cancel' => 'キャンセル',
        'start_build' => 'ビルドを開始',
        'credit' => 'クレジット',
        'credits' => 'クレジット',
        'builder_info' => 'ビルダー：',

        // Build Logs Modal
        'build_logs' => 'ビルドログ',
        'duration' => '所要時間：',
        'no_logs_available' => 'このビルドにはログがありません',
        'error' => 'エラー：',
        'close' => '閉じる',
        'download_build' => 'ビルドをダウンロード',

        // Build Download Modal
        'download_build_title' => 'ビルドをダウンロード',
        'aab_title' => 'Android App Bundle (AAB)',
        'aab_description' => 'これはAABファイルで、デバイスに直接インストールできません。AABファイルはGoogle Play Consoleにアップロードするために設計されており、Googleがユーザー向けに最適化されたAPKを生成します。',
        'scan_with_android' => 'Androidデバイスでスキャン',
        'qr_unavailable' => 'QRコードが利用できません',
        'download_options' => 'ダウンロードオプション',
        'download_options_description' => 'モバイルデバイスでQRコードをスキャンするか、下のダイレクトダウンロードリンクを使用してください。',
        'download_format' => ':formatをダウンロード',
        'installation_note' => 'インストール：',
        'installation_help' => 'Androidの設定で「提供元不明のアプリ」を有効にする必要がある場合があります。',
        'download_aab_file' => 'AABファイルをダウンロード',
        'upload_to_play_console' => 'このファイルをGoogle Play Consoleにアップロードしてアプリを公開してください。',
        'next_steps' => '次のステップ：',
        'next_steps_help' => 'このAABファイルをGoogle Play Consoleのリリース > 本番/テストにアップロードしてください。Googleがユーザー向けに最適化されたAPKを自動生成します。',

        // Delete Build Modal
        'delete_build' => 'ビルドを削除',
        'delete_confirmation' => '本当に削除しますか',
        'build_suffix' => 'ビルドを？',
        'action_cannot_be_undone' => 'この操作は元に戻せません。',
    ],

    // App Preview Panel
    'preview' => [
        'no_build_selected' => 'ビルドが選択されていません',
        'select_build_help' => 'ビルドタブから完了したビルドを選択してここでプレビュー',
    ],

    // App Creation Form
    'creation' => [
        'website_url' => 'ウェブサイトURL',
        'app_id' => 'アプリID',
        'app_id_tooltip' => '一意のパッケージ識別子（作成後は変更不可）',
        'auto_generate_package' => 'アプリ名から自動生成',
        'package_name_help' => '逆ドメイン形式の一意識別子（例：com.company.app）。作成後は変更不可。',
        'theme_color' => 'テーマカラー',
        'theme_color_help' => 'アプリ全体で使用されるメインカラー。テキスト色はデフォルトの黒/白を使用し、後でカスタマイズ可能。',
        'layout_template' => 'レイアウトテンプレート',
        'layout_app_bar_drawer' => 'アプリバー + ドロワー',
        'layout_app_bar_tabs' => 'アプリバー + ナビゲーションタブ',
        'layout_app_bar' => 'アプリバー',
        'layout_blank' => 'ブランク',
        'layout_help' => 'アプリのナビゲーション構造を選択',
    ],

    // Delete Modals
    'modals' => [
        'cancel' => 'キャンセル',
        'delete' => '削除',
        'action_cannot_be_undone' => 'この操作は元に戻せません。',
        'delete_build' => 'ビルドを削除',
        'delete_build_confirmation' => '本当に削除しますか',
        'build_suffix' => 'ビルドを？',
        'delete_app_icon' => 'アプリアイコンを削除',
        'delete_icon_confirmation' => '本当にアイコンを削除しますか',
        'delete_keystore' => 'キーストアを削除',
        'delete_keystore_confirmation' => '本当に削除しますか',
        'delete_splashscreen_background' => 'スプラッシュスクリーン背景を削除',
        'delete_splashscreen_background_confirmation' => '本当にスプラッシュスクリーン背景画像を削除しますか',
        'delete_splashscreen_logo' => 'スプラッシュスクリーンロゴを削除',
        'delete_splashscreen_logo_confirmation' => '本当にスプラッシュスクリーンロゴを削除しますか',
        'delete_drawer_background' => 'ドロワー背景を削除',
        'delete_drawer_background_confirmation' => '本当にドロワー背景画像を削除しますか',
        'delete_dark_mode_logo' => 'ダークモードロゴを削除',
        'delete_dark_mode_logo_confirmation' => '本当にドロワーのダークモードロゴを削除しますか',
        'delete_light_mode_logo' => 'ライトモードロゴを削除',
        'delete_light_mode_logo_confirmation' => '本当にドロワーのライトモードロゴを削除しますか',
        'delete_page' => 'ページを削除',
        'delete_page_confirmation' => '本当に削除しますか',
        'delete_page_warning' => 'この操作は元に戻せません。このページがナビゲーションで使用されている場合、アクセスできなくなります。',
    ],

    // WordPress Notifications Settings
    'notifications_wp' => [
        'title' => 'プッシュ通知',
        'description' => 'プッシュ通知用にFirebase Cloud Messagingを設定',
        'enable_label' => 'プッシュ通知を有効化',
        'enable_help' => '新しい記事が公開されたときに通知を送信',
        'firebase_required_title' => 'Firebase設定が必要',
        'firebase_required_description' => 'アプリでプッシュ通知を有効にするには、下の両方の設定ファイルをアップロードしてください。',
        'google_services_label' => 'google-services.json',
        'file_uploaded' => 'ファイルがアップロードされました',
        'google_services_configured' => 'google-services.jsonが設定されています',
        'delete' => '削除',
        'delete_file_confirm' => '本当にこのファイルを削除しますか？',
        'upload_google_services' => 'google-services.jsonをアップロード',
        'google_services_help' => 'Firebase Consoleからダウンロード（最大1MB）',
        'google_services_instructions' => 'Firebase Console > プロジェクト設定 > アプリ > Androidアプリからダウンロード',
        'firebase_service_account_label' => 'Firebaseサービスアカウント（通知送信用）',
        'credentials_configured' => '認証情報が設定されています',
        'service_account_stored' => 'サービスアカウントは安全に保存されています',
        'delete_credentials_confirm' => '本当にこの認証情報を削除しますか？',
        'upload_service_account' => 'サービスアカウントJSONをアップロード',
        'service_account_help' => 'Firebase Consoleからダウンロード（最大2MB）',
        'service_account_instructions' => 'Firebase Console > プロジェクト設定 > サービスアカウント > 新しい秘密鍵を生成からダウンロード',
        'setup_title' => 'Firebaseのセットアップ方法：',
        'setup_step_1' => 'アクセス：',
        'setup_step_2' => 'プロジェクトを作成するか、既存のプロジェクトを選択',
        'setup_step_3' => 'パッケージ名でAndroidアプリを追加：',
        'setup_step_4' => 'ダウンロード',
        'setup_step_4_suffix' => 'して上にアップロード',
        'setup_step_5' => 'プロジェクト設定 > サービスアカウントに移動',
        'setup_step_6' => '新しい秘密鍵を生成して上にアップロード',
    ],

    // Toast Messages - Settings
    'toast' => [
        // General success/error
        'settings_saved' => ':section設定が正常に保存されました！',
        'settings_save_failed' => '設定の保存に失敗しました。もう一度お試しください。',

        // Design settings
        'design_saved' => 'デザイン設定が正常に保存されました！',

        // Navigation settings
        'navigation_saved' => 'ナビゲーション設定が正常に保存されました！',
        'home_tab_cannot_delete' => 'ホームタブは削除できません。ナビゲーションに必要です。',
        'home_tab_cannot_move' => 'ホームタブは最初に配置する必要があり、移動できません。',
        'cannot_move_below_home' => 'ホームタブの下にアイテムを移動できません。',
        'home_item_cannot_delete' => 'ホームアイテムは削除できません。ナビゲーションに必要です。',
        'home_item_cannot_move' => 'ホームアイテムは最初に配置する必要があり、移動できません。',
        'cannot_move_below_home_item' => 'ホームアイテムの下にアイテムを移動できません。',

        // Custom code
        'custom_code_saved' => 'カスタムコードが正常に保存されました！',
        'custom_code_save_failed' => 'カスタムコードの保存に失敗しました。もう一度お試しください。',
        'custom_code_no_access' => 'ご利用のプランにはカスタムコードへのアクセスが含まれていません。プランをアップグレードしてください。',

        // WebView settings
        'webview_saved' => 'WebView設定が正常に保存されました！',

        // Permissions settings
        'permissions_saved' => '権限が正常に保存されました！',

        // Drawer settings
        'drawer_saved' => 'ドロワー設定が正常に保存されました！',

        // General settings
        'general_saved' => '一般設定が正常に保存されました！',

        // Splashscreen settings
        'splashscreen_saved' => 'スプラッシュスクリーン設定が正常に保存されました！',

        // Icon settings
        'icon_uploaded' => 'アプリアイコンが正常にアップロードされました！',
        'icon_upload_failed' => 'アイコンのアップロードに失敗しました: :error',
        'icon_removed' => 'アプリアイコンが正常に削除されました！',
        'icon_remove_failed' => 'アイコンの削除に失敗しました。もう一度お試しください。',

        // Splashscreen modals
        'splashscreen_background_deleted' => 'スプラッシュスクリーンの背景画像が正常に削除されました！',
        'splashscreen_background_delete_failed' => '背景画像の削除に失敗しました。もう一度お試しください。',
        'splashscreen_logo_deleted' => 'スプラッシュスクリーンのロゴが正常に削除されました！',
        'splashscreen_logo_delete_failed' => 'ロゴの削除に失敗しました。もう一度お試しください。',

        // Drawer modals
        'drawer_background_deleted' => 'ドロワーの背景画像が正常に削除されました！',
        'drawer_background_delete_failed' => '背景画像の削除に失敗しました。もう一度お試しください。',
        'drawer_logo_deleted' => 'ドロワーのロゴが正常に削除されました！',
        'drawer_logo_delete_failed' => 'ロゴの削除に失敗しました。もう一度お試しください。',
        'drawer_logo_light_deleted' => 'ドロワーのライトモードロゴが正常に削除されました！',
        'drawer_logo_dark_deleted' => 'ドロワーのダークモードロゴが正常に削除されました！',

        // Notifications settings
        'notifications_saved' => '通知設定が正常に保存されました！',
        'firebase_credentials_deleted' => 'Firebase認証情報が正常に削除されました！',
        'firebase_credentials_delete_failed' => 'Firebase認証情報の削除に失敗しました。もう一度お試しください。',
        'google_services_deleted' => 'Google Servicesファイルが正常に削除されました！',
        'google_services_delete_failed' => 'Google Servicesファイルの削除に失敗しました。もう一度お試しください。',

        // Signing keys
        'keystore_updated' => 'キーストアが正常に更新されました！',
        'keystore_update_failed' => 'キーストアの更新に失敗しました。',
        'keystore_load_failed' => 'キーストアの読み込みに失敗しました。',
        'keystore_deleted' => 'キーストアが正常に削除されました！',
        'keystore_delete_failed' => 'キーストアの削除に失敗しました。もう一度お試しください。',
        'keystore_uploaded' => 'キーストアが正常にアップロードされました！',
        'keystore_upload_failed' => '署名キーのアップロードに失敗しました: :error',
        'keystore_generated' => 'キーストアが正常に生成されました！',
        'keystore_set_default' => 'デフォルトキーストアが正常に更新されました！',

        // Build modal
        'build_no_builders_platform' => ':platformプラットフォーム用のビルダーがありません。サポートに連絡するか、プランをアップグレードしてください。',
        'build_no_subscription' => 'アプリをビルドするにはアクティブなサブスクリプションが必要です。プランに登録してください。',
        'build_no_builders_plan' => 'ご利用のプランで利用可能なビルダーがありません。サポートに連絡するか、プランをアップグレードしてください。',
        'build_builder_not_available' => '選択したビルダーはご利用のプランでは利用できません。',
        'build_builder_unavailable' => '選択したビルダーは現在利用できません。',
        'build_builder_no_platform' => '選択したビルダーは:platformプラットフォームをサポートしていません。',
        'build_insufficient_credits' => 'ビルドクレジットが不足しています。このビルドには:countクレジットが必要です。プランをアップグレードするか、月次リセットをお待ちください。',
        'build_keystore_required' => 'リリースビルドにはAndroidキーストアが必要です。キーストアを選択してください。',
        'build_keystore_invalid' => '選択したキーストアは無効です。',
        'build_already_in_progress' => ':platformビルドが既に進行中です。完了までお待ちください。',
        'build_queued' => ':platformビルドが正常にキューに追加されました！ビルダーが利用可能になり次第処理されます。（残りクレジット: :credits）',
        'build_queued_on_builder' => ':platformビルドが:builderで正常にキューに追加されました！（残りクレジット: :credits）',
        'build_create_failed' => 'ビルドの作成に失敗しました: :error',
        'build_deleted' => 'ビルドが正常に削除されました！',
        'build_delete_failed' => 'ビルドの削除に失敗しました。もう一度お試しください。',

        // Hosted pages
        'hosted_page_saved' => 'ページが正常に保存されました！',
        'hosted_page_save_failed' => 'ページの保存に失敗しました。もう一度お試しください。',
        'hosted_page_deleted' => 'ページが正常に削除されました！',
        'hosted_page_delete_failed' => 'ページの削除に失敗しました。もう一度お試しください。',
        'hosted_page_limit_reached' => 'ご利用のプランのホステッドページの上限に達しました。',
        'hosted_page_no_access' => 'ご利用のプランにはホステッドページが含まれていません。カスタムページを作成するにはプランをアップグレードしてください。',

        // Additional toast keys for AndroidWordPress
        'features_saved' => '機能設定が正常に保存されました！',
        'content_saved' => 'コンテンツ設定が正常に保存されました！',
        'storage_link_missing' => 'ストレージリンクが見つかりません。実行してください: php artisan storage:link',
        'splashscreen_image_deleted' => 'スプラッシュスクリーンの背景画像が正常に削除されました！',
        'splashscreen_image_delete_failed' => '背景画像の削除に失敗しました。もう一度お試しください。',
        'logo_delete_failed' => 'ロゴの削除に失敗しました。もう一度お試しください。',
        'default_key_updated' => 'デフォルトの署名キーが正常に更新されました！',
        'default_key_update_failed' => 'デフォルトの署名キーの更新に失敗しました。',
        'keystore_uploaded_default' => 'キーストアがアップロードされ、デフォルトに設定されました！',
        'signing_key_upload_failed' => '署名キーのアップロードに失敗しました: :error',
        'page_not_found' => 'ページが見つかりません。',
        'page_deleted' => 'ページが正常に削除されました！',
        'page_delete_failed' => 'ページの削除に失敗しました。もう一度お試しください。',
        'page_updated' => 'ページが正常に更新されました！',
        'page_created' => 'ページが正常に作成されました！',
        'page_save_failed' => 'ページの保存に失敗しました。もう一度お試しください。',
        'page_limit_reached' => 'ご利用のプランの上限:maxページに達しました。',
        'hosted_pages_not_available' => 'ご利用のプランにはホステッドページが含まれていません。プランをアップグレードしてください。',
        'unauthorized' => '許可されていない操作です。',
        'home_tab_required' => 'ホームタブは削除できません。ナビゲーションに必要です。',
        'home_tab_first' => 'ホームタブは最初に残す必要があります。',
        'home_item_required' => 'ホーム項目は削除できません。',
        'build_no_builders' => ':platformプラットフォーム用のビルダーがありません。サポートに連絡するか、プランをアップグレードしてください。',
        'build_no_plan_builders' => 'ご利用のプランで利用可能なビルダーがありません。サポートに連絡するか、プランをアップグレードしてください。',
        'build_builder_platform_unsupported' => '選択したビルダーは:platformプラットフォームをサポートしていません。',
        'build_insufficient_credits' => 'ビルドクレジットが不足しています。このビルドには:creditsクレジットが必要です。プランをアップグレードするか、月次リセットをお待ちください。',
        'build_invalid_keystore' => '選択したキーストアは無効です。',
        'build_queued_no_builder' => ':platformビルドが正常にキューに追加されました！ビルダーが利用可能になり次第処理されます。（残りクレジット: :credits）',
        'build_queued_success' => ':platformビルドが:builderで正常にキューに追加されました！（残りクレジット: :credits）',
        'available_builder' => '利用可能なビルダー',
        'invalid_google_services_json' => '無効なJSONファイルです。有効なgoogle-services.jsonをアップロードしてください。',
        'invalid_google_services_structure' => '無効なgoogle-services.jsonです。必要なproject_infoまたはclientセクションがありません。',
        'invalid_firebase_service_account' => '無効なJSONファイルです。有効なFirebaseサービスアカウントファイルをアップロードしてください。',
        'invalid_firebase_service_account_type' => '無効なFirebaseサービスアカウントファイルです。typeフィールドが見つからないか無効です。',
        'settings_save_failed_error' => '設定の保存に失敗しました: :error',
        'file_delete_failed' => 'ファイルの削除に失敗しました: :error',
        'credentials_delete_failed' => '認証情報の削除に失敗しました: :error',
    ],

    // Editor Section Headers
    'sections' => [
        'general' => '一般',
        'general_description' => '基本情報と設定',
        'design' => 'デザイン',
        'design_description' => 'レイアウト、カラー、テーマ設定のカスタマイズ',
        'icon' => 'アイコン',
        'icon_description' => 'Android用アプリアイコンをアップロード',
        'splashscreen' => 'スプラッシュスクリーン',
        'splashscreen_description' => '起動画面の外観とアニメーションを設定',
        'navigation' => 'ナビゲーション',
        'navigation_description' => 'ナビゲーション項目とアプリバーボタンを管理',
        'drawer' => 'ドロワー設定',
        'drawer_description' => 'ドロワーメニューの外観とブランディングをカスタマイズ',
        'webview' => 'WebView設定',
        'webview_description' => 'WebViewの動作と機能を設定',
        'permissions' => '権限',
        'permissions_description' => 'アプリが要求するデバイス権限を設定',
        'custom_code' => 'カスタムコード',
        'custom_code_description' => 'カスタムCSSとJavaScriptをアプリに挿入',
        'hosted_pages' => 'ホステッドページ',
        'hosted_pages_description' => 'アプリ用のカスタムHTMLページを作成',
        'pages' => 'ページ',
        'add_page' => 'ページを追加',
        'notifications' => '通知',
        'notifications_description' => 'Firebase Cloud Messagingを設定',
        'builds' => 'ビルド',
        'builds_description' => 'デプロイ用のAndroid APKおよびAABファイルを生成',
        'credits' => 'クレジット',
        'new_build' => '新規ビルド',
        'signing' => '署名',
        'signing_description' => 'アプリ配布用の署名キーを管理',
        // WordPress-specific sections
        'general_description_wordpress' => '基本情報とWordPressサイト設定',
        'content' => 'コンテンツ',
        'content_description' => '投稿表示とコンテンツ設定',
        'features' => '機能',
        'features_description' => 'アプリ機能の有効化・無効化',
    ],

];
