<?php

return [
    // Page Titles
    'admin_overview' => 'Vue d\'ensemble admin',
    'overview_title' => 'Vue d\'ensemble',
    'users_title' => 'Utilisateurs',
    'subscriptions_title' => 'Abonnements',
    'transactions_title' => 'Transactions',
    'plans_title' => 'Forfaits',
    'builders_title' => 'Compilateurs',
    'plugins_title' => 'Plugins',
    'languages_title' => 'Langues',
    'cronjobs_title' => 'Tâches planifiées',
    'email_templates_title' => 'Modèles d\'e-mails',
    'audit_logs_title' => 'Journaux d\'audit',
    'settings_title' => 'Paramètres',

    // Page Subtitles
    'users_subtitle' => 'Gérez les utilisateurs et les comptes de la plateforme',
    'subscriptions_subtitle' => 'Surveillez les abonnements et la facturation des utilisateurs',
    'transactions_subtitle' => 'Consultez et gérez les transactions de paiement',
    'plans_subtitle' => 'Configurez les forfaits d\'abonnement et les tarifs',
    'builders_subtitle' => 'Gérez les compilateurs pour la création d\'applications',
    'plugins_subtitle' => 'Gérez les plugins installés',
    'languages_subtitle' => 'Gérez les langues disponibles',
    'cronjobs_subtitle' => 'Surveillez les tâches planifiées',
    'email_templates_subtitle' => 'Personnalisez les notifications e-mail envoyées aux utilisateurs',
    'cronjobs_subtitle_full' => 'Surveillez les tâches planifiées et l\'automatisation',
    'settings_subtitle_full' => 'Configurez les paramètres et préférences à l\'échelle du système',
    'search_settings' => 'Rechercher dans les paramètres...',
    'no_settings_found' => 'Aucun paramètre trouvé correspondant à',
    'system_settings' => 'Paramètres système',
    'clear_search' => 'Effacer la recherche',

    // Settings Sidebar Navigation
    'settings_section_general' => 'Général',
    'settings_section_plans' => 'Forfaits',
    'settings_section_auth' => 'Authentification',
    'settings_section_email' => 'E-mail',
    'settings_section_privacy' => 'Confidentialité',
    'settings_section_preview' => 'Aperçu',
    'settings_section_ai' => 'Chat IA',
    'settings_category_platform' => 'Plateforme',
    'settings_category_security' => 'Sécurité',
    'settings_category_integrations' => 'Intégrations',
    'audit_logs_subtitle' => 'Suivez les actions des utilisateurs et les événements système pour la conformité RGPD',
    'no_audit_logs_found' => 'Aucun journal d\'audit trouvé.',
    'search_audit_logs' => 'Rechercher par utilisateur, action, IP...',
    'date_time' => 'Date/Heure',
    'actor' => 'Acteur',
    'ip_address' => 'Adresse IP',
    'details' => 'Détails',
    'view_details' => 'Voir les détails',
    'system' => 'Système',
    'clear_filters' => 'Effacer les filtres',
    'to' => 'à',
    'settings_subtitle' => 'Configurez les paramètres système',

    // Users
    'add_user' => 'Ajouter un utilisateur',
    'edit_user' => 'Modifier l\'utilisateur',
    'create_user' => 'Créer un utilisateur',
    'delete_user' => 'Supprimer l\'utilisateur',
    'user_info' => 'Info utilisateur',
    'user_details' => 'Détails de l\'utilisateur',
    'no_users_found' => 'Aucun utilisateur trouvé.',
    'search_users' => 'Rechercher des utilisateurs...',
    'user_role' => 'Rôle',
    'user_plan' => 'Forfait',
    'user_joined' => 'Inscrit',
    'email_verified' => 'E-mail vérifié',
    'mark_email_verified' => 'Marquer l\'e-mail comme vérifié',
    'role_admin' => 'Administrateur',
    'role_user' => 'Utilisateur',
    'leave_blank_password' => 'Laissez vide pour conserver le mot de passe actuel',

    // Plans
    'add_plan' => 'Ajouter un forfait',
    'edit_plan' => 'Modifier le forfait',
    'create_plan' => 'Créer un forfait',
    'create_new_plan' => 'Créer un nouveau forfait',
    'update_plan' => 'Mettre à jour le forfait',
    'delete_plan' => 'Supprimer le forfait',
    'no_plans_found' => 'Aucun forfait trouvé.',
    'plan_features' => 'Fonctionnalités',
    'plan_price' => 'Prix',
    'plan_interval' => 'Intervalle de facturation',
    'monthly' => 'Mensuel',
    'yearly' => 'Annuel',
    'default_plan' => 'Forfait par défaut',
    'mark_as_default' => 'Définir comme forfait par défaut',
    'per_month' => '/mois',
    'subscribers' => 'abonnés',
    'plan_name' => 'Nom du forfait',
    'plan_name_placeholder' => 'Pro',
    'basic_information' => 'Informations de base',
    'usage_limits' => 'Limites d\'utilisation',
    'monthly_build_credits' => 'Crédits de compilation mensuels',
    'unlimited' => 'Illimité',
    'appetize_preview' => 'Aperçu Appetize',
    'hosted_pages' => 'Pages hébergées',
    'ai_assistant' => 'Assistant IA',
    'allow_own_api_keys' => 'Autoriser ses propres clés API',
    'permissions' => 'Permissions',
    'custom_css_js_injection' => 'Injection CSS/JS personnalisé',
    'api_access' => 'Accès API',
    'builder_access' => 'Accès aux compilateurs',
    'all_builders_allowed' => 'Tous les compilateurs autorisés',
    'select_builders' => 'Sélectionner les compilateurs',
    'builders_selected' => ':count compilateur sélectionné|:count compilateurs sélectionnés',
    'allow_all_builders' => 'Autoriser tous les compilateurs',
    'search_builders_placeholder' => 'Rechercher des compilateurs...',
    'features_pricing_display' => 'Fonctionnalités (affichage tarifs)',
    'feature_name' => 'Nom de la fonctionnalité',
    'included' => 'Inclus',
    'not_included' => 'Non inclus',
    'no_features_added' => 'Aucune fonctionnalité ajoutée. Ajoutez des fonctionnalités à afficher sur la page de tarification.',

    // Subscriptions
    'add_subscription' => 'Ajouter un abonnement',
    'subscription_details' => 'Détails de l\'abonnement',
    'no_subscriptions_found' => 'Aucun abonnement trouvé.',
    'search_subscriptions' => 'Rechercher des abonnements...',
    'renewal_date' => 'Date de renouvellement',
    'subscription_status' => 'Statut',
    'change_plan' => 'Changer de forfait',
    'cancel_subscription' => 'Annuler l\'abonnement',
    'next_billing' => 'Prochaine facturation',
    'no_plan' => 'Aucun forfait',
    'select_user' => 'Sélectionner un utilisateur',
    'select_plan' => 'Sélectionner un forfait',
    'payment_method_placeholder' => 'Manuel, Virement bancaire, etc.',

    // Transactions
    'transaction_details' => 'Détails de la transaction',
    'no_transactions_found' => 'Aucune transaction trouvée.',
    'search_transactions' => 'Rechercher des transactions...',
    'transaction_id' => 'ID',
    'transaction_date' => 'Date',
    'transaction_amount' => 'Montant',
    'payment_method' => 'Moyen de paiement',
    'payment_gateway' => 'la passerelle de paiement',
    'transaction_status' => 'Statut',
    'approve' => 'Approuver',
    'decline' => 'Refuser',
    'confirm_approval' => 'Confirmer l\'approbation',
    'confirm_decline' => 'Confirmer le refus',
    'approve_payment' => 'Approuver le paiement',
    'decline_payment' => 'Refuser le paiement',
    'approve_bank_transfer_confirm' => 'Êtes-vous sûr de vouloir approuver ce paiement par virement bancaire ? Cela activera l\'abonnement de l\'utilisateur.',
    'decline_bank_transfer_confirm' => 'Êtes-vous sûr de vouloir refuser ce paiement par virement bancaire ? Cela annulera l\'abonnement et notifiera l\'utilisateur.',

    // Builders
    'add_builder' => 'Ajouter un compilateur',
    'edit_builder' => 'Modifier le compilateur',
    'create_builder' => 'Créer un compilateur',
    'delete_builder' => 'Supprimer le compilateur',
    'no_builders_found' => 'Aucun compilateur trouvé.',
    'search_builders' => 'Rechercher des compilateurs...',
    'builder_name' => 'Nom du compilateur',
    'builder_url' => 'URL',
    'builder_status' => 'Statut',
    'builder_platform' => 'Plateforme',
    'builder_platforms' => 'Plateformes',
    'builder_name_placeholder' => 'Compilateur de production',
    'server_url_placeholder' => 'http://192.168.2.29',
    'server_key_placeholder' => 'Clé serveur générée',
    'builder_queue' => 'File d\'attente',
    'current_builds' => 'Compilations en cours',
    'total_builds' => 'Total des compilations',
    'server_url' => 'URL du serveur',
    'port' => 'Port',
    'server_key' => 'Clé serveur',
    'server_key_help' => 'Utilisée pour authentifier les requêtes API vers ce compilateur',
    'generate' => 'Générer',
    'max_queue' => 'File d\'attente max',
    'max_queue_help' => 'Nombre maximum de compilations simultanées',
    'build_credit_cost' => 'Coût en crédits de compilation',
    'credit_cost_help' => 'Crédits déduits par compilation',
    'supported_platforms' => 'Plateformes supportées',
    'select_platforms' => 'Sélectionner les plateformes',
    'platforms_selected' => ':count plateforme sélectionnée|:count plateformes sélectionnées',
    'platforms_help' => 'Sélectionnez une ou plusieurs plateformes supportées par ce compilateur',
    'no_platforms_available' => 'Aucune plateforme disponible',
    'no_builders_configured' => 'Aucun compilateur configuré.',
    'default' => 'Par défaut',
    'locked' => 'Verrouillé',
    'from_purchase_code' => 'Du code d\'achat',
    'purchase_code_not_set_warning' => 'Code d\'achat non configuré',
    'purchase_code_not_set_description' => 'Le compilateur par défaut nécessite un code d\'achat valide. Veuillez le configurer dans Paramètres > Général.',
    'server_key_from_purchase_code_help' => 'La clé serveur est automatiquement définie à partir de votre code d\'achat.',

    // Plugins
    'upload_plugin' => 'Téléverser un plugin',
    'configure_plugin' => 'Configurer',
    'delete_plugin' => 'Supprimer le plugin',
    'no_plugins_found' => 'Aucun plugin trouvé.',
    'plugin_name' => 'Nom',
    'plugin_version' => 'Version',
    'plugin_type' => 'Type',
    'plugin_status' => 'Statut',

    // Languages
    'add_language' => 'Ajouter une langue',
    'add_new_language' => 'Ajouter une nouvelle langue',
    'edit_language' => 'Modifier la langue',
    'create_language' => 'Créer une langue',
    'delete_language' => 'Supprimer la langue',
    'no_languages_found' => 'Aucune langue trouvée.',
    'cannot_delete_default_language' => 'Impossible de supprimer la langue par défaut ou principale.',
    'default_language_badge' => 'Par défaut',
    'language_name' => 'Nom de la langue',
    'language_code' => 'Code de la langue',
    'language_code_help' => 'Code ISO 639-1 à 2 lettres (ex. en, es, fr)',
    'language_code_from_folder' => 'Sélectionner parmi les dossiers de traduction disponibles',
    'language_flag' => 'Drapeau',
    'language_flag_help' => 'Emoji de drapeau',
    'language_flag_auto' => 'Le drapeau est défini automatiquement en fonction du code de la langue',
    'language_flag_country_code_help' => 'Code pays à 2 lettres (ex. us, gb, es)',
    'language_name_placeholder' => 'Français',
    'language_code_placeholder' => 'fr',
    'language_flag_placeholder' => '🇫🇷',
    'language_status' => 'Statut',
    'rtl_support' => 'Direction du texte',
    'rtl_enabled' => 'Droite à gauche (RTL)',
    'rtl_description' => 'Activer pour les langues comme l\'arabe, l\'hébreu, le persan et l\'ourdou',
    'translation_files_created' => 'Les fichiers de traduction seront créés dans : lang/:code/',
    'translation_files_auto_created' => 'Assurez-vous que les fichiers de traduction existent dans :path avant d\'ajouter cette langue. Copiez le dossier lang/en/, renommez-le avec votre code de langue et traduisez le contenu.',

    // Email Templates
    'edit_template' => 'Modifier le modèle',
    'edit_email_template' => 'Modifier le modèle d\'e-mail',
    'reset_template' => 'Réinitialiser aux valeurs par défaut',
    'no_templates_found' => 'Aucun modèle trouvé.',
    'template_subject' => 'Objet',
    'template_body' => 'Corps',
    'template_variables' => 'Variables disponibles',
    'subject_line' => 'Ligne d\'objet',
    'email_subject_placeholder' => 'Objet de l\'e-mail...',
    'email_body' => 'Corps de l\'e-mail',
    'click_to_insert' => 'Cliquez pour insérer à la position du curseur',
    'no_variables_available' => 'Aucune variable disponible pour ce modèle.',
    'quick_tips' => 'Conseils rapides',
    'variables_replaced' => 'Les variables sont remplacées par les données réelles lors de l\'envoi',
    'toolbar_format_tip' => 'Utilisez la barre d\'outils pour formater le texte, ajouter des liens et créer des listes',
    'link_tip' => 'Sélectionnez du texte et cliquez sur le bouton lien pour ajouter des liens cliquables',

    // Cronjobs
    'no_cronjobs_found' => 'Aucune tâche planifiée trouvée.',
    'no_cron_logs_found' => 'Aucun journal de tâches trouvé.',
    'search_logs' => 'Rechercher dans les journaux...',
    'job_name' => 'Nom de la tâche',
    'job' => 'Tâche',
    'last_run' => 'Dernière exécution',
    'next_run' => 'Prochaine exécution',
    'run_duration' => 'Durée',
    'started' => 'Démarré',
    'duration' => 'Durée',
    'triggered_by' => 'Déclenché par',
    'message' => 'Message',
    'all_jobs' => 'Toutes les tâches',
    'trigger_manually' => 'Déclencher manuellement',
    'status_success' => 'Succès',
    'status_running' => 'En cours',

    // Settings
    'general_settings' => 'Paramètres généraux',
    'email_settings' => 'Paramètres e-mail',
    'social_login_settings' => 'Connexion sociale',
    'appetize_settings' => 'Paramètres Appetize',
    'ai_settings' => 'Paramètres IA',
    'gdpr_settings' => 'Paramètres RGPD',

    // General Settings Fields
    'site_name' => 'Nom du site',
    'site_description' => 'Description du site',
    'site_tagline' => 'Slogan du site',
    'logo' => 'Logo',
    'logo_dark' => 'Logo mode sombre',
    'favicon' => 'Favicon',
    'default_theme' => 'Thème par défaut',
    'landing_page_enabled' => 'Activer la page d\'accueil',
    'system_currency' => 'Devise du système',
    'default_language' => 'Langue par défaut',
    'default_language_description' => 'Langue par défaut pour les nouveaux visiteurs et utilisateurs sans préférence',

    // Status Labels
    'status_active' => 'Actif',
    'status_inactive' => 'Inactif',
    'status_pending' => 'En attente',
    'status_expired' => 'Expiré',
    'status_cancelled' => 'Annulé',
    'status_completed' => 'Terminé',
    'status_failed' => 'Échoué',

    // Demo Mode
    'demo_mode_notice' => 'Les paramètres ne peuvent pas être modifiés en mode démo.',
    'disabled_in_demo' => 'Désactivé en mode démo',
    'hidden_in_demo' => 'Masqué en mode démo',

    // Plugins
    'plugins_title_full' => 'Plugins',
    'plugins_subtitle_full' => 'Étendez les fonctionnalités avec des plugins personnalisés',
    'no_plugins_installed' => 'Aucun plugin installé',
    'plugin_activate' => 'Activer',
    'plugin_deactivate' => 'Désactiver',
    'plugin_uninstall' => 'Désinstaller',
    'plugin_author' => 'par :author',

    // Languages
    'languages_title_full' => 'Langues',
    'languages_subtitle_full' => 'Gérez les traductions et la localisation',

    // Cronjobs
    'cronjobs_title_full' => 'Tâches planifiées',
    'cronjobs_tab_jobs' => 'Tâches planifiées',
    'cronjobs_tab_logs' => 'Journaux d\'exécution',
    'execute_job' => 'Exécuter',
    'executing_job' => 'Exécution...',

    // Email Settings
    'email_config_title' => 'Configuration e-mail',
    'email_config_subtitle' => 'Configurez les paramètres e-mail et le serveur SMTP',
    'mail_driver' => 'Pilote de messagerie',
    'php_mail' => 'PHP Mail',
    'smtp' => 'SMTP',
    'php_mail_description' => 'PHP Mail utilise la configuration de messagerie intégrée de votre serveur. Simple mais peut avoir des problèmes de délivrabilité sur certains serveurs.',
    'php_mail_warning' => 'Note : Certains hébergeurs désactivent la fonction mail() de PHP. Si les e-mails ne sont pas envoyés, envisagez de passer à SMTP.',
    'smtp_config' => 'Configuration du serveur SMTP',
    'smtp_host' => 'Hôte SMTP',
    'smtp_port' => 'Port SMTP',
    'smtp_username' => 'Nom d\'utilisateur SMTP',
    'smtp_password' => 'Mot de passe SMTP',
    'smtp_encryption' => 'Chiffrement',
    'encryption_tls' => 'TLS',
    'encryption_ssl' => 'SSL',
    'encryption_none' => 'Aucun',
    'admin_notifications' => 'Notifications administrateur',
    'admin_email' => 'E-mail de notification admin',
    'admin_email_help' => 'Adresse e-mail pour recevoir les notifications admin. Si vide, l\'e-mail de l\'administrateur connecté sera utilisé.',
    'notify_user_registered' => 'Nouvel utilisateur inscrit',
    'notify_subscription_created' => 'Nouvel abonnement créé',
    'notify_subscription_cancelled' => 'Abonnement annulé',
    'notify_payment_received' => 'Paiement reçu',
    'notify_payment_failed' => 'Paiement échoué',
    'notify_build_started' => 'Compilation démarrée',
    'notify_build_completed' => 'Compilation terminée',
    'notify_build_failed' => 'Compilation échouée',
    'test_email' => 'E-mail de test',
    'send_test_email' => 'Envoyer un e-mail de test',
    'sending' => 'Envoi...',
    'mail_from_name' => 'Nom d\'expéditeur',
    'mail_from_address' => 'Adresse d\'expéditeur',
    'php_mail_info' => 'PHP Mail utilise la configuration de messagerie intégrée de votre serveur (sendmail/postfix). Aucune configuration supplémentaire requise dans ce panneau.',
    'php_mail_switch_warning' => 'Note : Certains hébergeurs désactivent la fonction mail() de PHP. Si les e-mails échouent, passez à SMTP.',
    'admin_notifications_subtitle' => 'Configurez où les notifications de paiement admin sont envoyées',
    'admin_email_description' => 'Adresse e-mail pour recevoir les notifications admin. Également utilisée pour les e-mails de test.',
    'notification_events' => 'Événements de notification',
    'notification_events_description' => 'Sélectionnez les événements qui doivent déclencher des notifications admin',
    'event_subscription_activated' => 'Abonnement activé',
    'event_payment_completed' => 'Paiement terminé',
    'event_payment_failed' => 'Paiement échoué',
    'event_subscription_cancelled' => 'Abonnement annulé',
    'event_subscription_expired' => 'Abonnement expiré',
    'event_bank_transfer_pending' => 'Virement bancaire en attente',
    'event_user_registered' => 'Utilisateur inscrit',
    'event_build_completed' => 'Compilation terminée',
    'event_build_failed' => 'Compilation échouée',

    // Social Login Settings
    'auth_settings_title' => 'Paramètres d\'authentification',
    'auth_settings_subtitle' => 'Configurez les options d\'inscription et de connexion sociale',
    'enable_registration' => 'Activer l\'inscription',
    'enable_registration_description' => 'Autoriser les nouveaux utilisateurs à créer des comptes',
    'require_email_verification' => 'Exiger la vérification de l\'e-mail',
    'require_email_verification_description' => 'Si désactivé, les nouvelles inscriptions sont automatiquement vérifiées',
    'recaptcha_title' => 'reCAPTCHA v3',
    'recaptcha_description' => 'Protégez les formulaires d\'authentification contre les bots',
    'recaptcha_site_key' => 'Clé de site',
    'recaptcha_site_key_placeholder' => 'Votre clé de site reCAPTCHA v3',
    'recaptcha_secret_key' => 'Clé secrète',
    'recaptcha_secret_key_placeholder' => 'Votre clé secrète reCAPTCHA v3',
    'leave_blank_keep_current' => 'Laissez vide pour conserver l\'actuel',
    'google_login' => 'Google',
    'facebook_login' => 'Facebook',
    'github_login' => 'GitHub',
    'client_id' => 'ID client',
    'client_id_placeholder' => 'Votre ID client :provider',
    'client_secret' => 'Secret client',
    'client_secret_placeholder' => 'Votre secret client :provider',
    'app_id' => 'ID de l\'application',
    'app_id_placeholder' => 'Votre ID d\'application :provider',
    'app_secret' => 'Secret de l\'application',
    'app_secret_placeholder' => 'Votre secret d\'application :provider',
    'callback_url' => 'URL de rappel',
    'oauth_help' => 'Créez des identifiants OAuth dans la console développeur :provider. Utilisez l\'URL de rappel ci-dessus.',
    'test_connection' => 'Tester la connexion',
    'testing' => 'Test...',
    'configure_oauth' => 'Configurer les identifiants OAuth :provider',
    'add_url_to_console' => 'Ajoutez cette URL à votre :provider',
    'your_provider_key' => 'Votre :type :provider',
    'recaptcha_help' => 'Obtenez vos clés depuis la :link. Assurez-vous de sélectionner reCAPTCHA v3.',
    'recaptcha_console' => 'Console d\'administration Google reCAPTCHA',
    'get_api_key_from' => 'Obtenez votre clé API depuis :link',

    // General Settings
    'general_settings_title' => 'Paramètres généraux',
    'general_settings_subtitle' => 'Mettez à jour les informations et l\'image de marque de votre site',
    'site_name_label' => 'Nom du site',
    'site_description_label' => 'Description du site',
    'site_description_placeholder' => 'Utilisé pour la méta-description et le SEO',
    'site_tagline_label' => 'Slogan du site',
    'site_tagline_placeholder' => 'Court slogan affiché sous le logo',
    'site_tagline_help' => 'Affiché sous le logo dans le menu latéral et les pages de connexion',
    'purchase_code_label' => 'Code d\'achat',
    'purchase_code_help' => 'Votre licence ou code d\'achat pour cette installation (optionnel)',
    'logo_light' => 'Logo (Mode clair)',
    'logo_dark_label' => 'Logo (Mode sombre)',
    'delete_logo' => 'Supprimer le logo',
    'delete_dark_logo' => 'Supprimer le logo sombre',
    'delete_favicon' => 'Supprimer le favicon',
    'logo_help' => 'Recommandé : 200x50px (horizontal) ou 50x50px (carré). PNG, JPG, SVG avec fond transparent. Max 2 Mo.',
    'favicon_label' => 'Favicon',
    'favicon_help' => 'Recommandé : 32x32px ou 16x16px. PNG, ICO ou SVG. Max 1 Mo.',
    'default_theme_label' => 'Thème de couleur par défaut',
    'theme_system' => 'Système (Suivre les préférences de l\'appareil)',
    'theme_light' => 'Clair',
    'theme_dark' => 'Sombre',
    'theme_help' => 'Thème par défaut pour les nouveaux visiteurs. Les utilisateurs peuvent le modifier dans leurs paramètres.',
    'currency_label' => 'Devise du système',
    'currency_help' => 'Devise utilisée pour tous les tarifs et paiements. Cela détermine quelles passerelles de paiement sont disponibles.',
    'landing_page_toggle' => 'Activer la page d\'accueil publique',
    'landing_page_help' => 'Si désactivé, les visiteurs accédant à l\'URL racine (/) seront redirigés vers la page de connexion',

    // Plan Configuration Settings
    'plan_config_title' => 'Configuration des forfaits',
    'plan_config_subtitle' => 'Configurez les paramètres par défaut des forfaits pour les nouveaux utilisateurs',
    'default_plan_label' => 'Forfait par défaut',
    'default_plan_none' => 'Aucun (abonnement requis)',
    'default_plan_help' => 'Forfait attribué aux nouveaux utilisateurs lors de l\'inscription. Si aucun forfait n\'est sélectionné, les utilisateurs devront s\'abonner pour accéder aux fonctionnalités.',

    // AI Settings
    'ai_settings_title' => 'Assistant chat IA',
    'ai_settings_subtitle' => 'Configurez l\'assistant de création d\'applications propulsé par l\'IA',
    'enable_ai' => 'Activer l\'assistant chat IA',
    'enable_ai_description' => 'Permettre aux utilisateurs de créer et configurer des applications via une conversation IA',
    'enable_streaming' => 'Activer les réponses en streaming',
    'enable_streaming_description' => 'Diffuser les réponses IA mot par mot pour une expérience plus interactive',
    'streaming_warning' => 'Peut ne pas fonctionner sur tous les environnements d\'hébergement mutualisé',
    'ai_provider' => 'Fournisseur IA',
    'ai_provider_help' => 'Choisissez entre OpenAI (GPT-4.1) ou Anthropic (Claude)',
    'api_key' => 'Clé API',
    'enter_api_key' => 'Entrez votre clé API',
    'openai_console' => 'Console OpenAI',
    'anthropic_console' => 'Console Anthropic',
    'api_key_help' => 'Obtenez votre clé API depuis la :provider',
    'advanced_settings' => 'Paramètres avancés',
    'ai_model' => 'Modèle IA',
    'ai_model_help' => 'Sélectionnez le modèle IA à utiliser pour les réponses du chat',
    'temperature' => 'Température',
    'temperature_help' => 'Contrôle l\'aléatoire. Plus bas = plus concentré, Plus haut = plus créatif',
    'max_tokens' => 'Tokens de réponse max',
    'max_tokens_help' => 'Tokens maximum par réponse IA. Des valeurs plus élevées = réponses plus longues mais plus coûteuses',
    'auto_summarization' => 'Résumé automatique',
    'enable_summarization' => 'Activer le résumé automatique',
    'summarization_help' => 'Résume automatiquement les anciens messages pour réduire l\'utilisation de tokens dans les longues conversations',
    'summarization_threshold' => 'Seuil de résumé',
    'summarization_threshold_help' => 'Nombre de messages avant le déclenchement du résumé automatique',
    'summarization_keep_recent' => 'Conserver les messages récents',
    'summarization_keep_recent_help' => 'Nombre de messages récents à conserver',
    'summarization_max_length' => 'Longueur max du résumé',
    'summarization_max_length_help' => 'Nombre maximum de caractères pour le résumé',
    'chat_widget' => 'Widget de chat',
    'widget_position' => 'Position du widget',
    'position_bottom_right' => 'En bas à droite',
    'position_bottom_left' => 'En bas à gauche',
    'position_top_right' => 'En haut à droite',
    'position_top_left' => 'En haut à gauche',
    'position_help' => 'Où le widget de chat IA apparaît sur la page de l\'éditeur d\'application',

    // GDPR Settings
    'gdpr_settings_title' => 'Paramètres RGPD',
    'gdpr_settings_subtitle' => 'Configurez la conformité RGPD et les paramètres de confidentialité',
    'enable_cookie_consent' => 'Activer la bannière de consentement aux cookies',
    'enable_data_export' => 'Activer l\'export de données',
    'enable_account_deletion' => 'Activer la suppression de compte',
    'deletion_grace_period' => 'Délai de grâce pour la suppression de compte (jours)',
    'audit_log_retention' => 'Rétention des journaux d\'audit (jours)',

    // Appetize Settings
    'appetize_settings_title' => 'Paramètres Appetize',
    'appetize_settings_subtitle' => 'Configurez Appetize.io pour les aperçus d\'applications en direct',
    'appetize_api_token' => 'Jeton API Appetize',
    'appetize_api_token_help' => 'Obtenez votre jeton API depuis votre tableau de bord Appetize.io',

    // Delete/Action Modal Messages
    'delete_user_confirm' => 'Êtes-vous sûr de vouloir supprimer',
    'delete_builder_confirm' => 'Êtes-vous sûr de vouloir supprimer',
    'delete_plan_confirm' => 'Êtes-vous sûr de vouloir supprimer le forfait',
    'delete_plan_confirm_suffix' => '?',
    'delete_language_confirm' => 'Êtes-vous sûr de vouloir supprimer',
    'delete_language_note' => 'Cette action est irréversible. Les fichiers de traduction seront conservés pour la sécurité des données.',
    'uninstall_plugin' => 'Désinstaller le plugin',
    'uninstall_plugin_confirm' => 'Êtes-vous sûr de vouloir désinstaller',
    'cancel_subscription_confirm' => 'Êtes-vous sûr de vouloir annuler l\'abonnement de',
    'reset_email_template' => 'Réinitialiser le modèle d\'e-mail',
    'reset_template_confirm' => 'Êtes-vous sûr de vouloir réinitialiser',
    'reset_template_confirm_suffix' => 'à son contenu par défaut ?',
    'reset_template_warning' => 'Toutes les personnalisations que vous avez effectuées seront perdues.',
    'disabled_in_demo' => 'Désactivé en mode démo',

    // Plugin Upload Modal
    'plugin_file' => 'Fichier du plugin',
    'plugin_file_help' => 'Fichier ZIP (MAX. 10 Mo)',
    'installing_plugin' => 'Installation du plugin...',
    'installing' => 'Installation...',

    // Plugin Config Modal
    'configure_plugin_title' => 'Configurer :name',
    'no_config_required' => 'Aucune configuration requise',
    'no_config_required_desc' => 'Ce plugin ne nécessite aucune configuration.',

    // Appetize Settings Extended
    'appetize_integration_title' => 'Intégration Appetize.io',
    'appetize_integration_subtitle' => 'Configurez la fonctionnalité d\'aperçu d\'application en direct',
    'enable_appetize_integration' => 'Activer l\'intégration Appetize.io',
    'enable_appetize_description' => 'Permettre aux utilisateurs avec les forfaits Pro/Enterprise de prévisualiser les applications dans le navigateur',
    'appetize_api_token_placeholder' => 'Entrez votre jeton API Appetize.io',
    'appetize_api_token_link' => 'Obtenez votre jeton API depuis',
    'auto_upload_builds' => 'Téléverser automatiquement les compilations vers Appetize',
    'auto_upload_description' => 'Téléverser automatiquement les compilations réussies pour un aperçu instantané',
    'preview_retention_days' => 'Rétention des aperçus (jours)',
    'preview_retention_help' => 'Supprimer les anciens aperçus après ce nombre de jours pour économiser des coûts (1-30 jours)',
    'session_timeout_seconds' => 'Délai d\'expiration de session (secondes)',
    'session_timeout_help' => 'Délai d\'inactivité avant la fin de la session',
    'seconds_30' => '30 secondes',
    'minute_1' => '1 minute',
    'minutes_2' => '2 minutes',
    'minutes_3' => '3 minutes',
    'minutes_5' => '5 minutes',
    'minutes_10' => '10 minutes',

    // GDPR Settings Extended
    'gdpr_privacy_settings_title' => 'Paramètres RGPD et confidentialité',
    'gdpr_privacy_settings_subtitle' => 'Configurez la protection des données et la conformité en matière de confidentialité',
    'feature_toggles' => 'Activation des fonctionnalités',
    'cookie_consent_banner' => 'Bannière de consentement aux cookies',
    'cookie_consent_description' => 'Afficher la bannière de consentement aux cookies aux nouveaux visiteurs',
    'user_data_export' => 'Export de données utilisateur',
    'user_data_export_description' => 'Permettre aux utilisateurs de demander une copie de leurs données',
    'user_account_deletion' => 'Suppression de compte utilisateur',
    'user_account_deletion_description' => 'Permettre aux utilisateurs de demander la suppression de leur compte',
    'policy_versions' => 'Versions des politiques',
    'policy_versions_help' => 'La mise à jour des versions des politiques déclenchera un nouveau consentement pour les utilisateurs.',
    'privacy_policy' => 'Politique de confidentialité',
    'terms_of_service' => 'Conditions d\'utilisation',
    'cookie_policy' => 'Politique des cookies',
    'data_retention_periods' => 'Périodes de rétention des données (jours)',
    'retention_transactions' => 'Transactions',
    'retention_transactions_help' => 'Min 365 jours (obligation légale)',
    'retention_inactive_accounts' => 'Comptes inactifs',
    'retention_expired_builds' => 'Compilations expirées',
    'retention_audit_logs' => 'Journaux d\'audit',
    'retention_data_exports' => 'Exports de données',
    'grace_periods_rate_limits' => 'Délais de grâce et limites de taux',
    'account_deletion_grace_period' => 'Délai de grâce pour la suppression de compte (jours)',
    'account_deletion_grace_help' => 'Temps avant que le compte soit définitivement supprimé',
    'data_export_rate_limit' => 'Limite de taux pour l\'export de données (heures)',
    'data_export_rate_limit_help' => 'Temps minimum entre les demandes d\'export',

    // App/Plan Settings
    'plan_configuration' => 'Configuration des forfaits',
    'plan_configuration_subtitle' => 'Configurez les paramètres par défaut des forfaits pour les nouveaux utilisateurs',
    'default_plan_option_none' => 'Aucun (abonnement requis)',
    'default_plan_description' => 'Forfait attribué aux nouveaux utilisateurs. Sélectionnez « Aucun » pour exiger un abonnement avant utilisation.',

    // Overview Stats
    'overview_subtitle' => 'Statistiques à l\'échelle du système et métriques d\'administration',
    'date_range_today' => 'Aujourd\'hui',
    'date_range_week' => 'Semaine',
    'date_range_month' => 'Mois',
    'date_range_year' => 'Année',
    'date_range_all' => 'Tout le temps',
    'auto_refresh' => 'Actualisation auto',
    'total_system_users' => 'Total des utilisateurs système',
    'active_subscriptions' => 'Abonnements actifs',
    'revenue_label' => 'Revenus :period',
    'total_apps' => 'Total des applications',
    'vs_last_month' => 'vs mois dernier',
    'total_builds_stat' => 'Total des compilations',
    'completed_today' => 'Terminées aujourd\'hui',
    'build_success_rate' => 'Taux de réussite des compilations',
    'pending_queue' => 'File d\'attente',
    'total_transactions' => 'Total des transactions',
    'active_plans' => 'Forfaits actifs',
    'active_builders' => 'Compilateurs actifs',
    'revenue_trends' => 'Tendances des revenus (12 mois)',
    'build_activity' => 'Activité de compilation (30 derniers jours)',
    'revenue_by_gateway' => 'Revenus par passerelle de paiement',
    'no_revenue_data' => 'Aucune donnée de revenus disponible',
    'total_revenue' => 'Revenus totaux',
    'platform_distribution' => 'Distribution par plateforme',
    'no_apps_created' => 'Aucune application créée',
    'pending_payments' => 'Paiements en attente',
    'active_users_7d' => 'Utilisateurs actifs (7j)',
    'notifications_today' => 'Notifications (aujourd\'hui)',
    'build_performance_by_platform' => 'Performance des compilations par plateforme',
    'platform' => 'Plateforme',
    'completed' => 'Terminées',
    'failed' => 'Échouées',
    'success_rate' => 'Taux de réussite',
    'avg_duration' => 'Durée moy.',
    'revenue_label_short' => 'Revenu',
    'builds_label' => 'Compilations',
    'recent_user_registrations' => 'Inscriptions récentes',
    'no_users_yet' => 'Aucun utilisateur',
    'recent_builds' => 'Compilations récentes',
    'no_builds_yet' => 'Aucune compilation',
    'recent_transactions' => 'Transactions récentes',
    'no_transactions_yet' => 'Aucune transaction',

    // Cronjobs Manager
    'cronjobs_tab_scheduled' => 'Tâches',
    'cronjobs_tab_execution_logs' => 'Journaux d\'exécution',

    // Payment Gateway Configuration
    'payment_gateways' => [
        // Common
        'api_credentials' => 'Identifiants API',
        'webhook_configuration' => 'Configuration du webhook',
        'webhook_url' => 'URL du webhook',
        'copy' => 'Copier',
        'copied' => 'Copié !',
        'copy_failed' => 'Échec de la copie. Veuillez sélectionner et copier l\'URL manuellement.',
        'required_webhook_events' => 'Événements webhook requis',
        'features' => 'Fonctionnalités',
        'supported_features' => 'Fonctionnalités supportées',
        'secret_key' => 'Clé secrète',
        'webhook_secret' => 'Secret du webhook',
        'webhook_signing_secret' => 'Secret de signature du webhook',
        'optional' => 'Optionnel',

        // SSL Warning
        'ssl_warning' => 'Avertissement :',
        'ssl_warning_stripe' => 'Votre site n\'utilise pas HTTPS. Stripe requiert HTTPS pour les webhooks et l\'utilisation en production.',
        'ssl_warning_paypal' => 'Votre site n\'utilise pas HTTPS. Les webhooks PayPal nécessitent une connexion HTTPS sécurisée. Veuillez activer SSL/TLS avant la mise en production.',
        'ssl_warning_paystack' => 'Votre site n\'utilise pas HTTPS. Les webhooks Paystack nécessitent une connexion HTTPS sécurisée. Veuillez activer SSL/TLS avant la mise en production.',

        // Stripe
        'stripe' => [
            'get_started' => 'Commencer avec Stripe',
            'get_api_keys' => 'Obtenez vos clés API depuis',
            'dashboard_link' => 'Tableau de bord Stripe → Développeurs → Clés API',
            'secret_key_placeholder' => 'sk_live_...',
            'secret_key_help' => 'Utilisez la clé de test (sk_test_) pour les tests, la clé live (sk_live_) pour la production',
            'webhook_url_help' => 'Ajoutez cette URL dans le tableau de bord Stripe → Développeurs → Webhooks',
            'webhook_secret_placeholder' => 'whsec_...',
            'webhook_secret_help' => 'Obtenez ceci après avoir créé le point de terminaison webhook dans le tableau de bord Stripe',
            'events_help' => 'Sélectionnez ces événements lors de la création de votre point de terminaison webhook :',
            'feature_currencies' => '135+ devises supportées mondialement',
            'feature_intervals' => 'Tous les intervalles de facturation supportés',
            'feature_renewal' => 'Renouvellement automatique des abonnements',
            'feature_customer_management' => 'Gestion des clients',
            'feature_signature_verification' => 'Vérification de signature webhook',
            'feature_refund' => 'Gestion des remboursements',
            'feature_sca' => 'Conforme SCA (Authentification forte du client)',
        ],

        // PayPal
        'paypal' => [
            'client_id' => 'ID client',
            'client_id_help' => 'Obtenez ceci depuis le tableau de bord développeur PayPal',
            'client_secret' => 'Secret client',
            'client_secret_help' => 'Gardez ce secret et ne le partagez jamais publiquement',
            'sandbox_mode' => 'Mode Sandbox',
            'sandbox_mode_help' => 'Activez pour tester avec PayPal Sandbox. Désactivez pour les transactions réelles.',
            'webhook_url_help' => 'Ajoutez cette URL dans vos paramètres webhook PayPal',
            'webhook_id' => 'ID du webhook',
            'webhook_id_help' => 'ID du webhook depuis le tableau de bord PayPal pour la vérification de signature (requis pour la sécurité)',
            'events_help' => 'Assurez-vous d\'activer ces événements dans votre configuration webhook PayPal :',
        ],

        // Razorpay
        'razorpay' => [
            'get_started' => 'Commencer avec Razorpay',
            'get_api_keys' => 'Obtenez vos clés API depuis',
            'dashboard_link' => 'Tableau de bord Razorpay → Paramètres → Clés API',
            'key_id' => 'ID de clé',
            'key_id_placeholder' => 'rzp_live_...',
            'key_id_help' => 'Utilisez la clé de test (rzp_test_) pour les tests, la clé live (rzp_live_) pour la production',
            'key_secret' => 'Secret de clé',
            'key_secret_help' => 'Gardez ce secret et ne le partagez jamais publiquement',
            'webhook_url_help' => 'Ajoutez cette URL dans le tableau de bord Razorpay → Paramètres → Webhooks',
            'webhook_secret_placeholder' => 'Entrez le secret du webhook',
            'webhook_secret_help' => 'Obtenez ceci depuis le tableau de bord Razorpay après avoir créé le webhook',
            'events_help' => 'Activez ces événements dans le tableau de bord Razorpay → Paramètres → Webhooks :',
            'feature_currencies' => '100+ devises supportées',
            'feature_intervals' => 'Tous les intervalles de facturation (quotidien, hebdomadaire, mensuel, annuel)',
            'feature_payment_methods' => 'UPI, Cartes, NetBanking, Wallets, EMI',
            'feature_renewal' => 'Renouvellement automatique des abonnements',
            'feature_signature_verification' => 'Vérification de signature webhook',
            'feature_refund' => 'Gestion des remboursements',
            'feature_decimal' => 'Support des devises à trois décimales (KWD, BHD, etc.)',
        ],

        // Paystack
        'paystack' => [
            'get_started' => 'Commencer avec Paystack',
            'get_api_keys' => 'Obtenez vos clés API depuis',
            'dashboard_link' => 'Tableau de bord Paystack → Paramètres → Clés API & Webhooks',
            'secret_key_help' => 'Obtenez ceci depuis le tableau de bord Paystack (utilisez la clé de test pour les tests, la clé live pour la production)',
            'webhook_url_help' => 'Ajoutez cette URL dans vos paramètres webhook Paystack',
            'webhook_secret_help' => 'Optionnel : Pour la vérification de signature webhook (recommandé pour la production)',
            'webhook_secret_placeholder' => 'Laissez vide pour ignorer la vérification de signature',
            'events_help' => 'Activez ces événements dans le tableau de bord Paystack → Paramètres → Clés API & Webhooks :',
            'feature_currencies' => 'Devises : NGN, USD, GHS, ZAR, KES',
            'feature_intervals' => 'Intervalles : Quotidien, Hebdomadaire, Mensuel (1, 3, 6 mois), Annuel',
            'feature_renewal' => 'Renouvellement automatique des abonnements',
            'feature_signature_verification' => 'Vérification de signature webhook',
            'feature_interval_limitation' => 'Support d\'intervalles limité (voir documentation)',
        ],

        // Crypto.com
        'cryptocom' => [
            'get_started' => 'Commencer avec Crypto.com Pay',
            'get_api_keys' => 'Obtenez vos identifiants API depuis',
            'dashboard_link' => 'Tableau de bord Crypto.com Pay',
            'monthly_only_title' => 'Intervalles mensuels uniquement',
            'monthly_only_description' => 'Crypto.com Pay ne supporte actuellement que les intervalles de facturation mensuels. Les abonnements quotidiens, hebdomadaires et annuels ne sont pas supportés.',
            'secret_key_placeholder' => 'Entrez votre clé secrète Crypto.com Pay',
            'secret_key_help' => 'Obtenez ceci depuis le tableau de bord Crypto.com Pay',
            'webhook_url_help' => 'Ajoutez cette URL dans vos paramètres webhook Crypto.com Pay',
            'webhook_secret_placeholder' => 'Entrez le secret de signature webhook',
            'webhook_secret_help' => 'Requis pour la vérification de signature webhook',
            'events_help' => 'Activez ces événements dans le tableau de bord Crypto.com Pay :',
            'feature_crypto_fiat' => 'Acceptez les paiements en crypto-monnaie et en monnaie fiduciaire',
            'feature_currencies' => '30+ devises supportées',
            'feature_renewal' => 'Renouvellement automatique des abonnements',
            'feature_signature_verification' => 'Vérification de signature webhook HMAC SHA-256',
            'feature_monthly_only' => 'Intervalles mensuels uniquement (quotidien/hebdomadaire/annuel non supportés)',
        ],

        // Bank Transfer
        'bank_transfer' => [
            'manual_approval_title' => 'Approbation manuelle requise',
            'manual_approval_description' => 'Les paiements par virement bancaire nécessitent une vérification manuelle. Les utilisateurs verront les instructions ci-dessous après avoir initié le paiement. Les administrateurs doivent approuver ou refuser les paiements dans',
            'transactions_link' => 'Transactions',
            'instructions_title' => 'Instructions de virement bancaire',
            'instructions_label' => 'Instructions pour les utilisateurs',
            'instructions_placeholder' => "Entrez les détails de votre compte bancaire et les instructions de virement ici...\n\nExemple :\n\nNom de la banque : Banque ABC\nTitulaire du compte : Nom de votre entreprise\nNuméro de compte : 123456789\nCode Swift : ABCDEFGH\nRéférence : [L'utilisateur verra son ID d'abonnement]\n\nVeuillez inclure votre ID d'abonnement dans la référence de paiement et envoyer une preuve de paiement à facturation@votreentreprise.com",
            'instructions_help' => 'Ces instructions seront affichées aux utilisateurs après avoir sélectionné un forfait. Incluez les détails du compte bancaire, le format de référence et les étapes de vérification.',
            'workflow_title' => 'Comment fonctionnent les paiements par virement bancaire :',
            'workflow_step_1' => 'L\'utilisateur sélectionne un forfait et choisit le virement bancaire comme moyen de paiement',
            'workflow_step_2' => 'Un abonnement et une transaction en attente sont créés',
            'workflow_step_3' => 'L\'utilisateur voit les instructions que vous avez configurées ci-dessus',
            'workflow_step_4' => 'L\'utilisateur effectue le virement bancaire manuellement',
            'workflow_step_5' => 'L\'administrateur reçoit une notification du paiement en attente',
            'workflow_step_6' => 'L\'administrateur approuve le paiement → abonnement activé et crédits rechargés',
            'workflow_step_7' => 'L\'administrateur refuse le paiement → abonnement et transaction supprimés',
            'feature_currencies' => 'Toutes les devises supportées',
            'feature_intervals' => 'Tous les intervalles de facturation supportés (quotidien, hebdomadaire, mensuel, annuel)',
            'feature_simple_setup' => 'Configuration simple - aucun identifiant API requis',
            'feature_manual_verification' => 'Vérification manuelle pour la sécurité',
            'feature_no_fees' => 'Pas de frais de transaction ni de dépendance tierce',
            'feature_admin_approval' => 'Nécessite une approbation admin pour chaque paiement',
            'feature_no_renewal' => 'Pas de renouvellement automatique des abonnements',
        ],
    ],

    // Plan Features (dynamic)
    'feature_unlimited_build_credits' => 'Crédits de compilation illimités',
    'feature_build_credits' => ':count crédits de compilation',
    'feature_all_builders' => 'Accès à tous les compilateurs actifs',
    'feature_builder_access' => 'Accès aux compilateurs',
    'feature_single_builder' => 'Accès à un seul compilateur',
    'feature_multiple_builders' => 'Accès à :count compilateurs',
    'feature_custom_code' => 'Injection CSS/JS personnalisé',
    'feature_api_access' => 'Accès API',
    'feature_unlimited_hosted_pages' => 'Pages hébergées illimitées',
    'feature_hosted_pages' => ':count pages hébergées par application',
    'feature_hosted_pages_disabled' => 'Pages hébergées',
    'feature_unlimited_ai_chat' => 'Chat IA illimité',
    'feature_ai_tokens' => ':count jetons IA/mois',
    'feature_own_ai_key' => 'Utilisez votre propre clé API IA',
    'feature_ai_chat' => 'Assistant chat IA',

    // Impersonation
    'impersonate' => 'Incarner',
    'impersonate_user' => 'Incarner l\'utilisateur',
    'impersonation_started' => 'Vous incarnez maintenant :name',
    'impersonation_stopped' => 'Incarnation terminée. Bon retour !',
    'impersonating_as' => 'Affichage en tant que :name',
    'exit_impersonation' => 'Quitter',
    'return_to_admin' => 'Retour à l\'admin',
    'not_impersonating' => 'Vous n\'incarnez actuellement aucun utilisateur.',
    'admin_blocked_during_impersonation' => 'La zone admin est bloquée pendant l\'incarnation. Quittez d\'abord l\'incarnation.',
    'impersonation_disabled_demo' => 'L\'incarnation est désactivée en mode démo.',
    'only_admins_can_impersonate' => 'Seuls les administrateurs peuvent incarner des utilisateurs.',
];
